package com.elitesland.tw.tw5.base.demo.vacation.service.impl;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.base.demo.convert.UserVacationApplyDtlConvert;
import com.elitesland.tw.tw5.base.demo.vacation.model.entity.UserVacationApplyDtlDO;
import com.elitesland.tw.tw5.base.demo.vacation.model.payload.UserVacationApplyDtlPayload;
import com.elitesland.tw.tw5.base.demo.vacation.model.query.UserVacationApplyDtlQuery;
import com.elitesland.tw.tw5.base.demo.vacation.model.vo.UserVacationApplyDtlVO;
import com.elitesland.tw.tw5.base.demo.vacation.repo.dao.UserVacationApplyDtlDao;
import com.elitesland.tw.tw5.base.demo.vacation.repo.UserVacationApplyDtlRepo;
import com.elitesland.tw.tw5.base.demo.vacation.service.UserVacationApplyDtlService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;

import java.util.List;


/**
 * @author : WWW
 * @date : 2024-1-18
 * @desc : 用户请假申请明细Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class UserVacationApplyDtlServiceImpl implements UserVacationApplyDtlService {


    private final UserVacationApplyDtlDao userVacationApplyDtlDao;

    private final UserVacationApplyDtlRepo userVacationApplyDtlRepo;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public UserVacationApplyDtlVO save(UserVacationApplyDtlPayload userVacationApplyDtlPayload) {

        checkData(userVacationApplyDtlPayload);
        UserVacationApplyDtlDO userVacationApplyDtlDO = new UserVacationApplyDtlDO();
        userVacationApplyDtlDO = UserVacationApplyDtlConvert.INSTANCE.p2d(userVacationApplyDtlPayload);
        UserVacationApplyDtlDO res = userVacationApplyDtlRepo.save(userVacationApplyDtlDO);
        return UserVacationApplyDtlConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public UserVacationApplyDtlVO updateAll(UserVacationApplyDtlPayload userVacationApplyDtlPayload) {

        Assert.notNull(userVacationApplyDtlPayload.getId(), "id is null");
        UserVacationApplyDtlVO res = save(userVacationApplyDtlPayload);
        return res;

    }


    @Override
    public UserVacationApplyDtlVO get(Long id) {

        if (null == id) {
            return null;
        }
        UserVacationApplyDtlVO res = userVacationApplyDtlDao.get(id);
        return res;

    }


    @Override
    public PagingVO<UserVacationApplyDtlVO> page(UserVacationApplyDtlQuery userVacationApplyDtlQuery) {

        PagingVO<UserVacationApplyDtlVO> res = userVacationApplyDtlDao.page(userVacationApplyDtlQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = userVacationApplyDtlDao.del(ids);
        return res;

    }

    @Override
    public List<UserVacationApplyDtlVO> getList(UserVacationApplyDtlQuery userVacationApplyDtlQuery) {

        List<UserVacationApplyDtlVO> res = userVacationApplyDtlDao.getList(userVacationApplyDtlQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param userVacationApplyDtlPayload
     */
    private void checkData(UserVacationApplyDtlPayload userVacationApplyDtlPayload) {

        Assert.notNull(userVacationApplyDtlPayload.getApplyId(), "applyId不能为空");

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long update(UserVacationApplyDtlPayload userVacationApplyDtlPayload) {
        Assert.notNull(userVacationApplyDtlPayload.getId(), "id不能为空");
        Long res = userVacationApplyDtlDao.update(userVacationApplyDtlPayload);
        return res;
    }


}

