package com.elitesland.tw.tw5.base.demo.vacation.service.impl;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.base.common.TwException;
import com.elitesland.tw.tw5.base.demo.common.HrBaseEnum;
import com.elitesland.tw.tw5.base.demo.convert.UserVacationApplyConvert;
import com.elitesland.tw.tw5.base.demo.vacation.model.entity.UserVacationApplyDO;
import com.elitesland.tw.tw5.base.demo.vacation.model.payload.UserVacationApplyPayload;
import com.elitesland.tw.tw5.base.demo.vacation.model.query.UserVacationApplyQuery;
import com.elitesland.tw.tw5.base.demo.vacation.model.vo.UserVacationApplyVO;
import com.elitesland.tw.tw5.base.demo.vacation.repo.dao.UserVacationApplyDao;
import com.elitesland.tw.tw5.base.demo.vacation.repo.UserVacationApplyRepo;
import com.elitesland.tw.tw5.base.demo.vacation.service.UserVacationApplyService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-1-18
 * @desc : 用户假期申请Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class UserVacationApplyServiceImpl implements UserVacationApplyService {


    private final UserVacationApplyDao userVacationApplyDao;

    private final UserVacationApplyRepo userVacationApplyRepo;

//    private final WorkflowUtil workflowUtil;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public UserVacationApplyVO save(UserVacationApplyPayload userVacationApplyPayload) {

        checkData(userVacationApplyPayload);
        UserVacationApplyDO userVacationApplyDO = new UserVacationApplyDO();
        userVacationApplyDO = UserVacationApplyConvert.INSTANCE.p2d(userVacationApplyPayload);
        UserVacationApplyDO res = userVacationApplyRepo.save(userVacationApplyDO);
        // 开启工作流
        startWorkFlow(res);
        return UserVacationApplyConvert.INSTANCE.d2v(res);

    }


    public Long startWorkFlow(UserVacationApplyDO res) {
        // 发起工作流程
        HashMap<String, Object> varMaps = new HashMap<>();
        Assert.notNull(res.getUserId(), "userId不能为空");
        // 变更资源审批
        varMaps.put("Activity_111kevq", res.getUserId());

        //发起流程审批
//        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
//                HrBaseEnum.BASE_BU_CHANGE.getCode(),
//                HrBaseEnum.BASE_BU_CHANGE.getDesc(),
//                res.getId().toString(), varMaps));

//        String procInstId = processInfo.getProcInstId();
//        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();
        String procInstId = "";
        ProcInstStatus procInstStatus = null;

        // 回写单据的工作流信息
        UserVacationApplyPayload payload = new UserVacationApplyPayload();
        payload.setProcInstId(procInstId);
        payload.setProcInstStatus(procInstStatus);
        payload.setId(res.getId());
        Long update = userVacationApplyDao.update(payload);
        return update;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public UserVacationApplyVO updateAll(UserVacationApplyPayload userVacationApplyPayload) {

        Assert.notNull(userVacationApplyPayload.getId(), "id is null");
        UserVacationApplyVO res = save(userVacationApplyPayload);
        return res;

    }


    @Override
    public UserVacationApplyVO get(Long id) {

        if (null == id) {
            return null;
        }
        UserVacationApplyVO res = userVacationApplyDao.get(id);
        return res;

    }


    @Override
    public PagingVO<UserVacationApplyVO> page(UserVacationApplyQuery userVacationApplyQuery) {

        PagingVO<UserVacationApplyVO> res = userVacationApplyDao.page(userVacationApplyQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = userVacationApplyDao.del(ids);
        return res;

    }

    @Override
    public List<UserVacationApplyVO> getList(UserVacationApplyQuery userVacationApplyQuery) {

        List<UserVacationApplyVO> res = userVacationApplyDao.getList(userVacationApplyQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param userVacationApplyPayload
     */
    private void checkData(UserVacationApplyPayload userVacationApplyPayload) {

        if (StringUtils.isBlank(userVacationApplyPayload.getType())) {
            throw new TwException("类型不能为空");
        }
        if (null == userVacationApplyPayload.getUserId()) {
            throw new TwException("用户id不能为空");
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long update(UserVacationApplyPayload userVacationApplyPayload) {
        Assert.notNull(userVacationApplyPayload.getId(), "id不能为空");
        Long res = userVacationApplyDao.update(userVacationApplyPayload);
        return res;
    }


}

