package com.elitesland.tw.tw5.base.ancillary.api;

import com.elitesland.tw.tw5.base.ancillary.CommonApplication;
import com.elitesland.tw.tw5.base.ancillary.model.query.ComSelectionQuery;
import com.elitesland.tw.tw5.base.ancillary.model.vo.ComSelectionVO;
import com.elitesland.tw.tw5.base.common.TwOutputUtil;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import java.util.List;


/**
 * selection rpcService
 * @author zhangyongqiang
 */
@FeignClient(name = "${tw5.openfeignClients.selection:tw-svr5-common}", path = ComSelectionRpcService.URI)
public interface ComSelectionRpcService {

    String URI = CommonApplication.URI_PREFIX + "/selection";

    /**
     * 列表查询
     *
     * @param query query
     * @return result
     */
    @GetMapping("/list")
    TwOutputUtil<List<ComSelectionVO>> queryList(ComSelectionQuery query);
}
