package com.elitesland.tw.tw5.base.ancillary.api;

import com.elitesland.tw.tw5.base.ancillary.CommonApplication;
import com.elitesland.tw.tw5.base.ancillary.model.query.OrgEmployeeQuery;
import com.elitesland.tw.tw5.base.ancillary.model.vo.OrgEmployeeVO;
import com.elitesland.tw.tw5.base.common.TwOutputUtil;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
 * employee rpcService
 * @author zhangyongqiang
 */
@FeignClient(name = "${tw5.openfeignClients.org:tw-svr5-common}", path = OrgEmployeeRpcService.URI)
public interface OrgEmployeeRpcService {

    String URI = CommonApplication.URI_PREFIX + "/employee";

    /**
     * 列表查询
     *
     * @param query query
     * @return result
     */
    @GetMapping("/list")
    TwOutputUtil<List<OrgEmployeeVO>> queryList(OrgEmployeeQuery query);

    /**
     * 通过用户id查询
     *
     * @param userId 用户id，注意不是employee的id
     * @return result
     */
    @GetMapping("/queryByUserId")
    TwOutputUtil<OrgEmployeeVO> queryByUserId(@RequestParam("userId")Long userId);


    // 项目字段，


    // BU
}
