package com.elitesland.tw.tw5.base.ancillary.api;

import com.elitesland.tw.tw5.base.ancillary.CommonApplication;
import com.elitesland.tw.tw5.base.ancillary.model.query.OrgOrganizationQuery;
import com.elitesland.tw.tw5.base.ancillary.model.vo.OrgOrganizationVO;
import com.elitesland.tw.tw5.base.common.TwOutputUtil;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
 * organization rpcService
 * @author zhangyongqiang
 */
@FeignClient(name = "${tw5.openfeignClients.org:tw-svr5-common}", path = OrgOrganizationRpcService.URI)
public interface OrgOrganizationRpcService {

    String URI = CommonApplication.URI_PREFIX + "/organization";

    /**
     * 列表查询
     *
     * @param query query
     * @return result
     */
    @GetMapping("/list")
    TwOutputUtil<List<OrgOrganizationVO>> queryList(OrgOrganizationQuery query);

    /**
     * 通过id查询
     *
     * @param id org id
     * @return result
     */
    @GetMapping("/queryByKey")
    TwOutputUtil<OrgOrganizationVO> queryByKey(@RequestParam("id")Long id);

    // 系统角色



    // 组织角色
    //
}
