package com.elitesland.tw.tw5.base.ancillary.model.payload;

import com.elitesland.tw.tw5.base.common.TwCommonPayload;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDate;


/**
 * 员工payload
 * @author yongqiang.zhang
 * @date 2024/3/7
 */
@Data
@ApiModel(description = "员工payload")
public class OrgEmployeePayload extends TwCommonPayload {

    @ApiModelProperty("用户user_id")
    private Long userId;

    @ApiModelProperty("自然人id")
    private Long personId;

    @ApiModelProperty("编号")
    private String objectNo;

    @ApiModelProperty("名称")
    private String objectName;

    @ApiModelProperty("状态")
    private String objectStatus;

    @ApiModelProperty("类型")
    private String objectType;

    @ApiModelProperty("企业微信ID")
    private String wecomId;

    @ApiModelProperty("人事状态")
    private String hrStatus;

    @ApiModelProperty("入职日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate enrollDate;

    @ApiModelProperty("岗位")
    private String position;

    @ApiModelProperty("排序")
    private Integer sortIndex;

    @ApiModelProperty("默认组织id")
    private Long defaultOrgId;

    @ApiModelProperty("拓展字段1")
    private String extString1;

    @ApiModelProperty("拓展字段2")
    private String extString2;

    @ApiModelProperty("拓展字段3")
    private String extString3;

    @ApiModelProperty("拓展字段4")
    private String extString4;

    @ApiModelProperty("拓展字段5")
    private String extString5;

    @ApiModelProperty("拓展字段6")
    private String extString6;

    @ApiModelProperty("拓展字段7")
    private String extString7;

    @ApiModelProperty("拓展字段8")
    private String extString8;

    @ApiModelProperty("拓展字段9")
    private String extString9;

    @ApiModelProperty("拓展字段10")
    private String extString10;

}
