package com.elitesland.tw.tw5.base.ancillary.model.vo;

import com.elitesland.tw.tw5.base.common.TwCommonVO;
import com.elitesland.tw.tw5.base.util.TreeInterface;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


/**
 * 选择项VO
 * @author yongqiang.zhang
 * @date 2024/3/5
 */
@Data
@ApiModel(description = "选择项vo")
public class ComSelectionVO extends TwCommonVO implements TreeInterface<ComSelectionVO>, Cloneable  {

    @ApiModelProperty("功能id")
    private Long functionId;
    @ApiModelProperty("功能id名称")
    private String functionIdDesc;

    @ApiModelProperty("选择项key")
    private String selectionKey;

    @ApiModelProperty("设置项名称")
    private String selectionName;

    @ApiModelProperty("设置项内容国际化")
    private String selectionNameLocale;

    @ApiModelProperty("设置项值")
    private String selectionValue;

    @ApiModelProperty("上级ID")
    private Long parentId;
    @ApiModelProperty("上级ID名称")
    private String parentIdDesc;

    @ApiModelProperty("排序号")
    private Integer sortNo;

    @ApiModelProperty("是否允许修改")
    private Boolean allowChange;

    @ApiModelProperty("是否禁用")
    private Boolean disabled;

    @ApiModelProperty("拓展字段1")
    private String extString1;

    @ApiModelProperty("拓展字段2")
    private String extString2;

    @ApiModelProperty("拓展字段3")
    private String extString3;

    @ApiModelProperty("拓展字段4")
    private String extString4;

    @ApiModelProperty("拓展字段5")
    private String extString5;

    @ApiModelProperty("拓展字段6")
    private String extString6;

    @ApiModelProperty("拓展字段7")
    private String extString7;

    @ApiModelProperty("拓展字段8")
    private String extString8;

    @ApiModelProperty("拓展字段9")
    private String extString9;

    @ApiModelProperty("拓展字段10")
    private String extString10;

    /**
     * 子节点
     */
    private List<ComSelectionVO> children;

    @Override
    public List<ComSelectionVO> getChildren() {
        return children;
    }

    @Override
    public void setChildren(List<ComSelectionVO> children) {
        this.children = children;
    }

    @Override
    public Object getParentCode() {
        return getParentId();
    }

    @Override
    public Object getCode() {
        return getId();
    }

    @Override
    public ComSelectionVO clone() {
        ComSelectionVO o = null;
        try {
            o = (ComSelectionVO) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return o;
    }
}
