package com.elitesland.tw.tw5.base.ancillary.model.vo;

import com.elitesland.tw.tw5.base.common.TwCommonVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDate;


/**
 * 员工VO
 * @author yongqiang.zhang
 * @date 2024/3/8
 */
@Data
@ApiModel(description = "员工vo")
public class OrgEmployeeVO extends TwCommonVO {

    @ApiModelProperty("用户user_id")
    private Long userId;
    @ApiModelProperty("用户user_id名称")
    private String userIdDesc;

    @ApiModelProperty("自然人id")
    private Long personId;
    @ApiModelProperty("自然人id名称")
    private String personIdDesc;

    @ApiModelProperty("编号")
    private String objectNo;

    @ApiModelProperty("名称")
    private String objectName;

    @ApiModelProperty("状态")
    private String objectStatus;

    @ApiModelProperty("类型")
    private String objectType;

    @ApiModelProperty("企业微信ID")
    private String wecomId;
    @ApiModelProperty("企业微信ID名称")
    private String wecomIdDesc;

    @ApiModelProperty("人事状态")
    private String hrStatus;

    @ApiModelProperty("入职日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate enrollDate;

    @ApiModelProperty("岗位")
    private String position;

    @ApiModelProperty("排序")
    private Integer sortIndex;

    @ApiModelProperty("直属上级用户id，冗余字段")
    private String parentUserId;
    @ApiModelProperty("直属上级用户id，冗余字段名称")
    private String parentUserIdDesc;

    @ApiModelProperty("默认组织id")
    private Long defaultOrgId;
    @ApiModelProperty("默认组织id名称")
    private String defaultOrgIdDesc;

    @ApiModelProperty("拓展字段1")
    private String extString1;

    @ApiModelProperty("拓展字段2")
    private String extString2;

    @ApiModelProperty("拓展字段3")
    private String extString3;

    @ApiModelProperty("拓展字段4")
    private String extString4;

    @ApiModelProperty("拓展字段5")
    private String extString5;

    @ApiModelProperty("拓展字段6")
    private String extString6;

    @ApiModelProperty("拓展字段7")
    private String extString7;

    @ApiModelProperty("拓展字段8")
    private String extString8;

    @ApiModelProperty("拓展字段9")
    private String extString9;

    @ApiModelProperty("拓展字段10")
    private String extString10;

}
