package com.elitesland.tw.tw5.base.common;

import lombok.Data;

/**
 * <p>创建时间: 2019/12/16 17:20</p>
 *
 * @author <a href="mailto:yongqiang.zhang@elitesland.com?subject=简述你的问题&cc=&body=请描述你的问题">yongqiang.zhang</a>
 * @version 1.0
 */
@Data
public class TwMessage {

    /**
     * 国际化码
     */
    private String localeCode;

    /**
     * 返回信息
     */
    private String msg;

    public TwMessage() {}

    private TwMessage(String defaultMsg) {
        this.defaultMsg = defaultMsg;
    }


    private TwMessage(String localeCode, String defaultMsg, Object context) {
        this.localeCode = localeCode;
        this.defaultMsg = defaultMsg;
        this.context = context;
    }


    public String getMsg() {
        if (msg == null) {
            return defaultMsg;
        } else {
            return msg;
        }
    }

    /**
     * 默认信息
     */
    private String defaultMsg;

    /**
     * 消息上下文,用于带变量类型的提示
     */
    private Object context;

    public static TwMessage of(String defaultMsg) {
        return new TwMessage(defaultMsg);
    }


    public static TwMessage of(String localeCode, String defaultMsg,Object context) {
        return new TwMessage(localeCode, defaultMsg,context);
    }
}
