package com.elitesland.tw.tw5.base.util;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.auth.util.SecurityUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import java.lang.reflect.Field;

@Component
@RequiredArgsConstructor
@Slf4j
public class GlobalUtil {

    /**
     * 获取当前租户id
     *
     * @return
     */
    public static Long getTenantId() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            SecurityUtil.throwUnauthorizedException();
        }
        return user.getUser().getTenantId();
    }
    /**
     * 获取当前登录人用户信息
     *
     * @return
     */
    public static SysUserDTO getLoginUser() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            SecurityUtil.throwUnauthorizedException();
        }
        return user.getUser();
    }


    /**
     * 获取当前登录人用户信息
     *
     * @return
     */
    public static GeneralUserDetails getLoginGeneralUser() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            SecurityUtil.throwUnauthorizedException();
        }
        return user;
    }

    /**
     * 获取当前登录人userId
     *
     * @return
     */
    public static Long getLoginUserId() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            SecurityUtil.throwUnauthorizedException();
        }
        return user.getUser().getId();
    }

    /**
     * 获取当前登录人姓名
     *
     * @return
     */
    public static String getLoginUserName() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            SecurityUtil.throwUnauthorizedException();
        }
        String firstName = user.getUser().getFirstName();
        if (!StringUtils.hasText(firstName)) {
            firstName = user.getUser().getLastName();
        }
        return firstName;
    }


    /**
     * 数据合并
     *
     * @param origin      源数据（需要合并的数据）
     * @param destination 目标数据（需要被合并的数据）
     * @param <T>
     */
    public static <T> void mergeObject(T origin, T destination) {
        if (origin == null || destination == null) {
            return;
        }
        if (!origin.getClass().equals(destination.getClass())) {
            return;
        }

        Field[] fields = origin.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; i++) {
            try {
                fields[i].setAccessible(true);
                Object value = fields[i].get(origin);
                if (null != value) {
                    fields[i].set(destination, value);
                }
                fields[i].setAccessible(false);
            } catch (Exception e) {
            }
        }
    }



}
