package com.elitesland.tw.tw5.base.util;

import java.util.ArrayList;
import java.util.List;

/**
 * 树形数据接口
 */
public interface TreeInterface<E extends TreeInterface>  {

    List<E> getChildren();
    void setChildren(List<E> children);

    /**
     * 获取父节点编码
     * @return 父节点编码
     */
    Object getParentCode();

    /**
     * 获取该节点编码
     * @return 该节点编码
     */
    Object getCode();

    default void addChildren(E children) {
        if (getChildren() == null) {
            List<E> list = new ArrayList<>(0);
            setChildren(list);
        }
        getChildren().add(children);
    }

}
