package com.elitesland.tw.tw5.base.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 树形数据集合拓展
 *
 * @author 作者 : zyq
 */
public class TreeListUtil {

    /**
     * 树形集合数据递归循环
     * @param list 数据集合
     * @param action 要执行的动作
     * @param <E> 实现{@code TreeInterface}的实体类
     * @see TreeInterface
     */
    public static <E extends TreeInterface<E>> void treeListForEach(List<E> list, Consumer<E> action) {
        Objects.requireNonNull(action);
        if (list == null || list.size() == 0) {
            return;
        }
        list.forEach(data->{
            action.accept(data);
            if(data.getChildren()!=null){
                treeListForEach(data.getChildren(),action);
            }
        });
    }

    /**
     * 树形集合数据递归循环
     * @param list 数据集合
     * @param action 要执行的动作
     * @param initialLevel 初始级别
     * @param <E> 实现{@code TreeInterface}的实体类
     */
    public static <E extends TreeInterface<E>> void treeListForEach(List<E> list, BiConsumer<E,Integer> action, int initialLevel) {
        Objects.requireNonNull(action);
        if (list == null || list.size() == 0) {
            return;
        }
        list.forEach(data->{
            action.accept(data,initialLevel);
            if(data.getChildren()!=null){
                treeListForEach(data.getChildren(),action,initialLevel+1);
            }
        });
    }

    /**
     * 将集合转成树的形式
     * @param list 源数据集合
     * @param <E> 实现{@code TreeInterface}的实体类
     * @return 树集合
     */
    @SuppressWarnings("unchecked")
    public static <E extends TreeInterface<E>> List<E> toTree(List<E> list){
//        Class<E> entityClass = (Class<E>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[0];
//        E entity = entityClass.newInstance();
        if(list==null||list.size()==0){
            return list;
        }
        try {
            E root = (E) list.get(0).getClass().getDeclaredConstructor().newInstance();
            Map<Object, E> map = list.stream().collect(Collectors.toMap(E::getCode, Function.identity(),(entity1, entity2) -> entity1));
            list.forEach(view ->
                map.getOrDefault(view.getParentCode(), root).addChildren(view));
            return root.getChildren();
        } catch (InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return list;
    }

    /**
     * 树形集合数据递归循环(先处理子节点,后处理当前节点)
     * @param list 数据集合
     * @param action 要执行的动作
     * @param <E> 实现{@code TreeInterface}的实体类
     * @see TreeInterface
     */
    public static <E extends TreeInterface<E>> void treeListForEachAfter(List<E> list, Consumer<E> action) {
        Objects.requireNonNull(action);
        if (list == null || list.size() == 0) {
            return;
        }
        list.forEach(data->{
            if(data.getChildren()!=null){
                treeListForEachAfter(data.getChildren(),action);
            }
            action.accept(data);
        });
    }

    /**
     * 树集合 转正常list
     * @param list 树集合
     * @param <E> <E> 实现{@code TreeInterface}的实体类
     * @return 正常list
     */
    public static <E extends TreeInterface<E>> List<E> treeToList(List<E> list){
        List<E> returnList = new ArrayList<>();
        treeListForEachAfter(list, returnList::add);
        return returnList;
    }
}
