package com.elitesland.tw.tw5.base.util;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.redis.util.RedisUtils;
//import com.elitesland.tw.tw5.api.common.TwOutputUtil;
//import com.elitesland.tw.tw5.api.prd.org.dto.PrdOrgEmployeeDTO;
//import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeRpcService;
//import com.elitesland.tw.tw5.api.pms.PrdOrgEmployeeRpcService;
//import com.elitesland.tw.tw5.api.pms.PrdOrgEmployeeRpcService;
//import com.elitesland.tw.tw5.api.common.util.TreeListUtil;
//import com.elitesland.tw.tw5.api.prd.org.dto.PrdOrgEmployeeDTO;
//import com.elitesland.tw.tw5.api.prd.org.service.ComOrgEmployeeRpcService;
//import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeRpcService;
import com.elitesland.tw.tw5.base.ancillary.api.ComSelectionRpcService;
import com.elitesland.tw.tw5.base.ancillary.api.OrgEmployeeRpcService;
import com.elitesland.tw.tw5.base.ancillary.api.OrgOrganizationRpcService;
import com.elitesland.tw.tw5.base.ancillary.model.query.ComSelectionQuery;
import com.elitesland.tw.tw5.base.ancillary.model.query.OrgEmployeeQuery;
import com.elitesland.tw.tw5.base.ancillary.model.query.OrgOrganizationQuery;
import com.elitesland.tw.tw5.base.ancillary.model.vo.ComSelectionVO;
import com.elitesland.tw.tw5.base.ancillary.model.vo.OrgEmployeeVO;
import com.elitesland.tw.tw5.base.ancillary.model.vo.OrgOrganizationVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.*;

@Slf4j
@Component
@RequiredArgsConstructor
public class TwCacheUtil {

    private final RedisUtils redisUtils;

    private final ComSelectionRpcService comSelectionRpcService;
    private final OrgEmployeeRpcService orgEmployeeRpcService;
    private final OrgOrganizationRpcService orgOrganizationRpcService;


    // ===========用户缓存================
    private static Map<String, ComSelectionVO> selectionCacheMap = new HashMap<>();
    private static long lastLoadTimeSelection = 0L;
    private static long lastLoadTimeRedisSelection = 0L;

    /**
     * 加载系统选择项缓存
     */
    public void loadSelectionCache() {
        selectionCacheMap.clear();
        ComSelectionQuery query = new ComSelectionQuery();

        List<ComSelectionVO> selectionViews = comSelectionRpcService.queryList(query).getData();
        selectionViews.forEach(selectionView -> {
            selectionCacheMap.put(selectionView.getSelectionKey(), selectionView);
        });
        TreeListUtil.toTree(selectionViews);
        lastLoadTimeSelection = new Date().getTime();
        lastLoadTimeRedisSelection = lastLoadTimeSelection;
        redisUtils.set("lastLoadTimeRedisSelection",lastLoadTimeSelection);
        redisUtils.set("selectionCacheMap", selectionCacheMap);
    }

    /**
     * 从redis加载系统选择项缓存
     */
    @SuppressWarnings("unchecked")
    public void loadSelectionCacheFromRedis() {
        selectionCacheMap.clear();
        Object selectionCacheMap = redisUtils.get("selectionCacheMap");
        TwCacheUtil.selectionCacheMap = (Map<String, ComSelectionVO>) selectionCacheMap;
        lastLoadTimeRedisSelection = (long) redisUtils.get("lastLoadTimeRedisSelection");
    }

    /**
     * 获取系统选择项
     *
     * @param selectionKey 选择项key
     * @return 消息提醒
     */
    public ComSelectionVO getSelection(String selectionKey) {
        Object selectionRedisCacheTime = redisUtils.get("lastLoadTimeRedisSelection");
        if(selectionRedisCacheTime == null){
            loadSelectionCache();
        }else if(!selectionRedisCacheTime.toString().equals(lastLoadTimeRedisSelection+"")){
            loadSelectionCacheFromRedis();
        }

        ComSelectionVO prdSystemSelectionVO = selectionCacheMap.get(selectionKey);
        if (prdSystemSelectionVO == null && shouldLoadCache(lastLoadTimeSelection)) {
            loadSelectionCache();
            return selectionCacheMap.get(selectionKey);
        } else {
            return prdSystemSelectionVO;
        }
    }

    /**
     * 翻译系统选择项
     *
     * @param selectionKey 选择项key
     * @param value        选择项值
     * @return 选择项描述
     */
    public String transferSelection(String selectionKey, String value) {
        if (value == null) {
            return null;
        }
        ComSelectionVO selection = getSelection(selectionKey);
        String result = value;
        if (selection == null) {
            return result;
        }
        List<ComSelectionVO> children = selection.getChildren();
        if (children != null && children.size() > 0) {
            for (ComSelectionVO selectionView : children) {
                if (value.equals(selectionView.getSelectionValue())) {
                    result = selectionView.getSelectionName();
                    break;
                }
            }
        }
        return result;
    }

    /**
     * 翻译级联系统选择项
     *
     * @param selectionKey   选择项key
     * @param cascaderValues 级联值
     * @return 选择项描述
     */
    public String transferSelectionCascader(String selectionKey, String[] cascaderValues) {
        if (cascaderValues == null || cascaderValues.length == 0) {
            return null;
        }
        String result = cascaderValues[cascaderValues.length - 1];
        ComSelectionVO view = getSelection(selectionKey);
        if (view == null || view.getChildren() == null || view.getChildren().isEmpty()) {
            return result;
        }
        List<ComSelectionVO> children = view.getChildren();
        ComSelectionVO resultView = null;
        for (int i = 0; i < cascaderValues.length; i++) {
            int valueIndex = i;
            Optional<ComSelectionVO> view1 = children.stream()
                    .filter(selectionView -> selectionView.getSelectionValue().equals(cascaderValues[valueIndex]))
                    .findFirst();
            if (view1.isPresent()) {
                resultView = view1.get();
                children = resultView.getChildren();
            } else {
                return result;
            }

        }
        return resultView.getSelectionName();

    }

    // ===========用户缓存================
    private static Map<Long, OrgEmployeeVO> employeeCacheMap = new HashMap<>();
    private static long lastLoadTimeEmployee = 0L;
    private static long lastLoadTimeRedisEmployee = 0L;

    /**
     * 加载用户缓存
     */
    public void loadEmployeeCache() {
        employeeCacheMap.clear();
        OrgEmployeeQuery query = new OrgEmployeeQuery();

        List<OrgEmployeeVO> employeeViews = orgEmployeeRpcService.queryList(query).getData();
        employeeViews.forEach(employeeView -> {
            employeeCacheMap.put(employeeView.getUserId(), employeeView);
        });
        lastLoadTimeEmployee = new Date().getTime();
        lastLoadTimeRedisEmployee = lastLoadTimeEmployee;
        redisUtils.set("lastLoadTimeRedisEmployee",lastLoadTimeEmployee);
        redisUtils.set("employeeCacheMap", employeeCacheMap);
    }

    /**
     * 从redis加载用户缓存
     */
    @SuppressWarnings("unchecked")
    public void loadEmployeeCacheFromRedis() {
        employeeCacheMap.clear();
        Object employeeCacheMap = redisUtils.get("employeeCacheMap");
        TwCacheUtil.employeeCacheMap = (Map<Long, OrgEmployeeVO>) employeeCacheMap;
        lastLoadTimeRedisEmployee = (long) redisUtils.get("lastLoadTimeRedisEmployee");
    }

    /**
     * 获取员工
     *
     * @param id 员工id
     * @return 员工
     */
    public OrgEmployeeVO getEmployee(Long id) {
        Object employeeRedisCacheTime = redisUtils.get("lastLoadTimeRedisEmployee");
        if(employeeRedisCacheTime == null){
            loadEmployeeCache();
        }else if(!employeeRedisCacheTime.toString().equals(lastLoadTimeRedisEmployee+"")){
            loadEmployeeCacheFromRedis();
        }

        OrgEmployeeVO orgEmployeeVO = employeeCacheMap.get(id);
        if (orgEmployeeVO == null && shouldLoadCache(lastLoadTimeEmployee)) {
            loadEmployeeCache();
            return employeeCacheMap.get(id);
        } else {
            return orgEmployeeVO;
        }
    }

    /**
     * 翻译员工名称
     *
     * @param id 员工id
     * @return 员工描述
     */
    public String transferEmployee(Long id) {
        if (id == null) {
            return null;
        }
        OrgEmployeeVO employee = getEmployee(id);
        if (employee == null) {
            return null;
        }else {
            return employee.getObjectName();
        }

    }

    // ===========组织缓存================
    private static Map<Long, OrgOrganizationVO> organizationCacheMap = new HashMap<>();
    private static long lastLoadTimeOrganization = 0L;
    private static long lastLoadTimeRedisOrganization = 0L;

    /**
     * 加载组织缓存
     */
    public void loadOrganizationCache() {
        organizationCacheMap.clear();
        OrgOrganizationQuery query = new OrgOrganizationQuery();

        List<OrgOrganizationVO> organizationViews = orgOrganizationRpcService.queryList(query).getData();
        organizationViews.forEach(organizationView -> {
            organizationCacheMap.put(organizationView.getId(), organizationView);
        });
        lastLoadTimeOrganization = new Date().getTime();
        lastLoadTimeRedisOrganization = lastLoadTimeOrganization;
        redisUtils.set("lastLoadTimeRedisOrganization",lastLoadTimeOrganization);
        redisUtils.set("organizationCacheMap", organizationCacheMap);
    }

    /**
     * 从redis加载组织缓存
     */
    @SuppressWarnings("unchecked")
    public void loadOrganizationCacheFromRedis() {
        organizationCacheMap.clear();
        Object organizationCacheMap = redisUtils.get("organizationCacheMap");
        TwCacheUtil.organizationCacheMap = (Map<Long, OrgOrganizationVO>) organizationCacheMap;
        lastLoadTimeRedisOrganization = (long) redisUtils.get("lastLoadTimeRedisOrganization");
    }

    /**
     * 获取组织
     *
     * @param id 组织id
     * @return 组织
     */
    public OrgOrganizationVO getOrganization(Long id) {
        Object organizationRedisCacheTime = redisUtils.get("lastLoadTimeRedisOrganization");
        if(organizationRedisCacheTime == null){
            loadOrganizationCache();
        }else if(!organizationRedisCacheTime.toString().equals(lastLoadTimeRedisOrganization+"")){
            loadOrganizationCacheFromRedis();
        }

        OrgOrganizationVO orgOrganizationVO = organizationCacheMap.get(id);
        if (orgOrganizationVO == null && shouldLoadCache(lastLoadTimeOrganization)) {
            loadOrganizationCache();
            return organizationCacheMap.get(id);
        } else {
            return orgOrganizationVO;
        }
    }

    /**
     * 翻译组织名称
     *
     * @param id 组织id
     * @return 组织描述
     */
    public String transferOrganization(Long id) {
        if (id == null) {
            return null;
        }
        OrgOrganizationVO organization = getOrganization(id);
        if (organization == null) {
            return null;
        }else {
            return organization.getObjectName();
        }

    }

    /**
     * 获取不到缓存时是否应该重新
     *
     * @param lastLoadTime 上次加载缓存时间
     * @return 是否
     */
    private boolean shouldLoadCache(long lastLoadTime) {
        long interval = 1000L * 60;
        return new Date().getTime() - lastLoadTime > interval;

    }


}
