package com.elitesland.tw.tw5.base.util;

import com.elitesland.tw.tw5.base.common.TwException;
import com.elitesland.tw.tw5.base.common.TwOutputUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.payload.ApprovePayload;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@RequiredArgsConstructor
@Slf4j
public class WorkflowUtil {

    private final WorkflowService workflowService;


    /**
     * 创建工作流
     *
     * @param payload 请求参数
     * @return 流程信息或异常信息
     */
    public TwOutputUtil<ProcessInfo> startProcess(StartProcessPayload payload) {
        // 捕获工作流的异常 1、网络原因，重新发起 2、工作流本身的异常 需联系管理员
        try {
            WorkflowResult<ProcessInfo> workflowResult = workflowService.startProcess(payload);
            System.out.println("workflowResult:::" + workflowResult.toString());
            if (workflowResult.isSuccess()) {
                return TwOutputUtil.ok(workflowResult.getData());
            } else {
                // 工作流本身的异常 需联系管理员
                return TwOutputUtil.error("", "工作流创建异常，请联系管理员！");
            }
        } catch (Exception e) {
            log.error("openFeign异常={}", e.toString());
            // FeignClient异常
            return TwOutputUtil.error("", "未成功创建工作流，请稍后重试！");
        }

    }

    /**
     * 删除工作流
     *
     * @param payload 请求参数
     * @return 删除成功或者失败
     */
    public TwOutputUtil deleteProcess(DeleteProcessPayload payload) {
        // 捕获工作流的异常 1、网络原因，重新发起 2、工作流本身的异常 需联系管理员
        try {
            WorkflowResult workflowResult = workflowService.deleteProcess(payload);
            System.out.println("workflowResult:::" + workflowResult.toString());
            if (workflowResult.isSuccess()) {
                return TwOutputUtil.ok();
            } else {
                // 工作流本身的异常 需联系管理员
                return TwOutputUtil.error("", "工作流删除异常，请联系管理员！");
            }
        } catch (Exception e) {
            log.error("openFeign异常={}", e.toString());
            // FeignClient异常
            return TwOutputUtil.error("", "未成功删除工作流，请稍后重试！");
        }

    }

    /**
     * 修改流程实例节点审批人
     *
     * @param payload 请求参数
     * @return 修改成功或者失败
     */
    public TwOutputUtil setVariables(SetVariablesPayload payload) {
        try {
            WorkflowResult workflowResult = workflowService.setVariables(payload);
            System.out.println("workflowResult:::" + workflowResult.toString());
            if (workflowResult.isSuccess()) {
                return TwOutputUtil.ok();
            } else {
                // 工作流本身的异常 需联系管理员
                return TwOutputUtil.error("", "工作流修改节点审批人异常，请联系管理员！");
            }
        } catch (Exception e) {
            log.error("openFeign异常={}", e.toString());
            // FeignClient异常
            return TwOutputUtil.error("", "未成功修改节点审批人，请稍后重试！");
        }
    }

    /**
     * 将流程往前推一个节点
     *
     * @param payload 参数
     */
    public TwOutputUtil approve(ApprovePayload payload) {
        try {
            WorkflowResult workflowResult = workflowService.approve(payload);
            System.out.println("workflowResult:::" + workflowResult.toString());
            if (workflowResult.isSuccess()) {
                return TwOutputUtil.ok();
            } else {
                // 工作流本身的异常 需联系管理员
                return TwOutputUtil.error("", "工作流推进流程异常，请联系管理员！");
            }
        } catch (Exception e) {
            throw TwException.error("", "未成功推进工作流，请稍后重试！");
        }
    }

    /**
     * 获取当前节点信息
     *
     * @param procInstId 流程id
     * @return 流程信息或异常信息
     */
    public TwOutputUtil<TaskInfo> currentTaskInfo(String procInstId) {
        try {
            WorkflowResult<TaskInfo> workflowResult = workflowService.currentTaskInfo(procInstId);
            System.out.println("workflowResult:::" + workflowResult.toString());
            if (workflowResult.isSuccess()) {
                return TwOutputUtil.ok(workflowResult.getData());
            } else {
                // 工作流本身的异常 需联系管理员
                return TwOutputUtil.error("", "工作流推进流程异常，请联系管理员！");
            }
        } catch (Exception e) {
            throw TwException.error("", "工作流信息获取异常，请稍后重试！");
        }
    }

}
