/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.base.common.aspect;

import com.elitescloud.boot.redis.util.RedLockUtils;
import com.elitesland.tw.tw5.base.common.TwOutputUtil;
import com.elitesland.tw.tw5.base.common.annotation.DuplicateSubmissionPrevention;
import com.elitesland.tw.tw5.base.util.GlobalUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.RedissonRedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
@Order(value=1)
public class DuplicateSubmissionPreventionAspect {
    private static final Logger log = LoggerFactory.getLogger(DuplicateSubmissionPreventionAspect.class);
    private static final String REDIS_SEPARATOR = ":";
    private static final String DEFAULT_TIP_MSG = "\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c";
    private static final String UN_AUTHORIZATION = "UN_AUTHORIZATION";
    @Value(value="${spring.application.name:MyDuplicateSubmissionPrevention}")
    private String applicationName;
    private final RedLockUtils redLockUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(com.elitesland.tw.tw5.base.common.annotation.DuplicateSubmissionPrevention)")
    public Object doAround(ProceedingJoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        DuplicateSubmissionPrevention annotation = method.getAnnotation(DuplicateSubmissionPrevention.class);
        boolean enabled = annotation.enabled();
        if (enabled) {
            block12: {
                String redisLockKey = this.getRedisLockKey(annotation, joinPoint);
                RedissonRedLock redisLock = this.redLockUtils.getRedLock("redisLockKey");
                boolean getLock = false;
                try {
                    boolean tryLock = redisLock.tryLock(0L, annotation.timeIntervalMillis(), TimeUnit.MILLISECONDS);
                    if (tryLock) {
                        log.info("redisson\u83b7\u53d6\u5206\u6b65\u5f0f\u9501{},\u5f53\u524d\u7ebf\u7a0b\u540d\u79f0{}", (Object)redisLockKey, (Object)Thread.currentThread().getName());
                        getLock = true;
                        break block12;
                    }
                    String tipMsg = StringUtils.hasText((String)annotation.message()) ? annotation.message() : DEFAULT_TIP_MSG;
                    log.info("redisson\u672a\u83b7\u53d6\u5206\u6b65\u5f0f\u9501{},\u5f53\u524d\u7ebf\u7a0b\u540d\u79f0{}", (Object)redisLockKey, (Object)Thread.currentThread().getName());
                    TwOutputUtil twOutputUtil = TwOutputUtil.error("", tipMsg);
                    return twOutputUtil;
                }
                catch (InterruptedException e) {
                    log.info("redisson\u672a\u83b7\u53d6\u5206\u6b65\u5f0f\u9501\u5f02\u5e38");
                }
                finally {
                    if (getLock) {
                        redisLock.unlock();
                        log.info("redisson\u5206\u6b65\u5f0f\u9501\u91ca\u653e");
                    }
                }
            }
            try {
                return joinPoint.proceed();
            }
            catch (Throwable e) {
                log.error("\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38");
                e.printStackTrace();
                return TwOutputUtil.error("", "\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38");
            }
        }
        try {
            return joinPoint.proceed();
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38");
            e.printStackTrace();
            return TwOutputUtil.error("", "\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38");
        }
    }

    private String getRedisLockKey(DuplicateSubmissionPrevention annotation, ProceedingJoinPoint joinPoint) {
        String[] parametersArr = annotation.parametersForUniqueFlagGeneration();
        String className = joinPoint.getSignature().getDeclaringType().getSimpleName();
        String methodName = joinPoint.getSignature().getName();
        Object[] args = joinPoint.getArgs();
        Object parameterEntity = args[0];
        StringBuilder annotateParameterSb = new StringBuilder();
        try {
            Long loginUserId = GlobalUtil.getLoginUserId();
            annotateParameterSb.append(loginUserId);
            annotateParameterSb.append("_");
        }
        catch (Exception e) {
            annotateParameterSb.append(UN_AUTHORIZATION);
            annotateParameterSb.append("_");
        }
        for (String parameter : parametersArr) {
            try {
                Field nameField = parameterEntity.getClass().getDeclaredField(parameter);
                nameField.setAccessible(true);
                String name = "" + nameField.get(parameterEntity);
                annotateParameterSb.append(name);
                annotateParameterSb.append("_");
            }
            catch (Exception e) {
                log.info("{}\u672a\u80fd\u6210\u529f\u83b7\u53d6", (Object)parameter);
            }
        }
        return this.applicationName + REDIS_SEPARATOR + className + REDIS_SEPARATOR + methodName + REDIS_SEPARATOR + annotateParameterSb;
    }

    public DuplicateSubmissionPreventionAspect(RedLockUtils redLockUtils) {
        this.redLockUtils = redLockUtils;
    }
}

