/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.base.util;

import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitesland.tw.tw5.base.ancillary.api.ComSelectionRpcService;
import com.elitesland.tw.tw5.base.ancillary.api.OrgEmployeeRpcService;
import com.elitesland.tw.tw5.base.ancillary.api.OrgOrganizationRpcService;
import com.elitesland.tw.tw5.base.ancillary.model.query.ComSelectionQuery;
import com.elitesland.tw.tw5.base.ancillary.model.query.OrgEmployeeQuery;
import com.elitesland.tw.tw5.base.ancillary.model.query.OrgOrganizationQuery;
import com.elitesland.tw.tw5.base.ancillary.model.vo.ComSelectionVO;
import com.elitesland.tw.tw5.base.ancillary.model.vo.OrgEmployeeVO;
import com.elitesland.tw.tw5.base.ancillary.model.vo.OrgOrganizationVO;
import com.elitesland.tw.tw5.base.util.TreeListUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TwCacheUtil {
    private static final Logger log = LoggerFactory.getLogger(TwCacheUtil.class);
    private final RedisUtils redisUtils;
    private final ComSelectionRpcService comSelectionRpcService;
    private final OrgEmployeeRpcService orgEmployeeRpcService;
    private final OrgOrganizationRpcService orgOrganizationRpcService;
    private static Map<String, ComSelectionVO> selectionCacheMap = new HashMap<String, ComSelectionVO>();
    private static long lastLoadTimeSelection = 0L;
    private static long lastLoadTimeRedisSelection = 0L;
    private static Map<Long, OrgEmployeeVO> employeeCacheMap = new HashMap<Long, OrgEmployeeVO>();
    private static long lastLoadTimeEmployee = 0L;
    private static long lastLoadTimeRedisEmployee = 0L;
    private static Map<Long, OrgOrganizationVO> organizationCacheMap = new HashMap<Long, OrgOrganizationVO>();
    private static long lastLoadTimeOrganization = 0L;
    private static long lastLoadTimeRedisOrganization = 0L;

    public void loadSelectionCache() {
        selectionCacheMap.clear();
        ComSelectionQuery query = new ComSelectionQuery();
        List<ComSelectionVO> selectionViews = this.comSelectionRpcService.queryList(query).getData();
        selectionViews.forEach(selectionView -> selectionCacheMap.put(selectionView.getSelectionKey(), (ComSelectionVO)selectionView));
        TreeListUtil.toTree(selectionViews);
        lastLoadTimeRedisSelection = lastLoadTimeSelection = new Date().getTime();
        this.redisUtils.set("lastLoadTimeRedisSelection", (Object)lastLoadTimeSelection);
        this.redisUtils.set("selectionCacheMap", selectionCacheMap);
    }

    public void loadSelectionCacheFromRedis() {
        selectionCacheMap.clear();
        Object selectionCacheMap = this.redisUtils.get("selectionCacheMap");
        TwCacheUtil.selectionCacheMap = (Map)selectionCacheMap;
        lastLoadTimeRedisSelection = (Long)this.redisUtils.get("lastLoadTimeRedisSelection");
    }

    public ComSelectionVO getSelection(String selectionKey) {
        Object selectionRedisCacheTime = this.redisUtils.get("lastLoadTimeRedisSelection");
        if (selectionRedisCacheTime == null) {
            this.loadSelectionCache();
        } else if (!selectionRedisCacheTime.toString().equals("" + lastLoadTimeRedisSelection)) {
            this.loadSelectionCacheFromRedis();
        }
        ComSelectionVO prdSystemSelectionVO = selectionCacheMap.get(selectionKey);
        if (prdSystemSelectionVO == null && this.shouldLoadCache(lastLoadTimeSelection)) {
            this.loadSelectionCache();
            return selectionCacheMap.get(selectionKey);
        }
        return prdSystemSelectionVO;
    }

    public String transferSelection(String selectionKey, String value) {
        if (value == null) {
            return null;
        }
        ComSelectionVO selection = this.getSelection(selectionKey);
        String result = value;
        if (selection == null) {
            return result;
        }
        List<ComSelectionVO> children = selection.getChildren();
        if (children != null && children.size() > 0) {
            for (ComSelectionVO selectionView : children) {
                if (!value.equals(selectionView.getSelectionValue())) continue;
                result = selectionView.getSelectionName();
                break;
            }
        }
        return result;
    }

    public String transferSelectionCascader(String selectionKey, String[] cascaderValues) {
        if (cascaderValues == null || cascaderValues.length == 0) {
            return null;
        }
        String result = cascaderValues[cascaderValues.length - 1];
        ComSelectionVO view = this.getSelection(selectionKey);
        if (view == null || view.getChildren() == null || view.getChildren().isEmpty()) {
            return result;
        }
        List<ComSelectionVO> children = view.getChildren();
        ComSelectionVO resultView = null;
        int i = 0;
        while (i < cascaderValues.length) {
            int valueIndex = i++;
            Optional<ComSelectionVO> view1 = children.stream().filter(selectionView -> selectionView.getSelectionValue().equals(cascaderValues[valueIndex])).findFirst();
            if (!view1.isPresent()) {
                return result;
            }
            resultView = view1.get();
            children = resultView.getChildren();
        }
        return resultView.getSelectionName();
    }

    public void loadEmployeeCache() {
        employeeCacheMap.clear();
        OrgEmployeeQuery query = new OrgEmployeeQuery();
        List<OrgEmployeeVO> employeeViews = this.orgEmployeeRpcService.queryList(query).getData();
        employeeViews.forEach(employeeView -> employeeCacheMap.put(employeeView.getUserId(), (OrgEmployeeVO)((Object)employeeView)));
        lastLoadTimeRedisEmployee = lastLoadTimeEmployee = new Date().getTime();
        this.redisUtils.set("lastLoadTimeRedisEmployee", (Object)lastLoadTimeEmployee);
        this.redisUtils.set("employeeCacheMap", employeeCacheMap);
    }

    public void loadEmployeeCacheFromRedis() {
        employeeCacheMap.clear();
        Object employeeCacheMap = this.redisUtils.get("employeeCacheMap");
        TwCacheUtil.employeeCacheMap = (Map)employeeCacheMap;
        lastLoadTimeRedisEmployee = (Long)this.redisUtils.get("lastLoadTimeRedisEmployee");
    }

    public OrgEmployeeVO getEmployee(Long id) {
        Object employeeRedisCacheTime = this.redisUtils.get("lastLoadTimeRedisEmployee");
        if (employeeRedisCacheTime == null) {
            this.loadEmployeeCache();
        } else if (!employeeRedisCacheTime.toString().equals("" + lastLoadTimeRedisEmployee)) {
            this.loadEmployeeCacheFromRedis();
        }
        OrgEmployeeVO orgEmployeeVO = employeeCacheMap.get(id);
        if (orgEmployeeVO == null && this.shouldLoadCache(lastLoadTimeEmployee)) {
            this.loadEmployeeCache();
            return employeeCacheMap.get(id);
        }
        return orgEmployeeVO;
    }

    public String transferEmployee(Long id) {
        if (id == null) {
            return null;
        }
        OrgEmployeeVO employee = this.getEmployee(id);
        if (employee == null) {
            return null;
        }
        return employee.getObjectName();
    }

    public void loadOrganizationCache() {
        organizationCacheMap.clear();
        OrgOrganizationQuery query = new OrgOrganizationQuery();
        List<OrgOrganizationVO> organizationViews = this.orgOrganizationRpcService.queryList(query).getData();
        organizationViews.forEach(organizationView -> organizationCacheMap.put(organizationView.getId(), (OrgOrganizationVO)((Object)organizationView)));
        lastLoadTimeRedisOrganization = lastLoadTimeOrganization = new Date().getTime();
        this.redisUtils.set("lastLoadTimeRedisOrganization", (Object)lastLoadTimeOrganization);
        this.redisUtils.set("organizationCacheMap", organizationCacheMap);
    }

    public void loadOrganizationCacheFromRedis() {
        organizationCacheMap.clear();
        Object organizationCacheMap = this.redisUtils.get("organizationCacheMap");
        TwCacheUtil.organizationCacheMap = (Map)organizationCacheMap;
        lastLoadTimeRedisOrganization = (Long)this.redisUtils.get("lastLoadTimeRedisOrganization");
    }

    public OrgOrganizationVO getOrganization(Long id) {
        Object organizationRedisCacheTime = this.redisUtils.get("lastLoadTimeRedisOrganization");
        if (organizationRedisCacheTime == null) {
            this.loadOrganizationCache();
        } else if (!organizationRedisCacheTime.toString().equals("" + lastLoadTimeRedisOrganization)) {
            this.loadOrganizationCacheFromRedis();
        }
        OrgOrganizationVO orgOrganizationVO = organizationCacheMap.get(id);
        if (orgOrganizationVO == null && this.shouldLoadCache(lastLoadTimeOrganization)) {
            this.loadOrganizationCache();
            return organizationCacheMap.get(id);
        }
        return orgOrganizationVO;
    }

    public String transferOrganization(Long id) {
        if (id == null) {
            return null;
        }
        OrgOrganizationVO organization = this.getOrganization(id);
        if (organization == null) {
            return null;
        }
        return organization.getObjectName();
    }

    private boolean shouldLoadCache(long lastLoadTime) {
        long interval = 60000L;
        return new Date().getTime() - lastLoadTime > interval;
    }

    public TwCacheUtil(RedisUtils redisUtils, ComSelectionRpcService comSelectionRpcService, OrgEmployeeRpcService orgEmployeeRpcService, OrgOrganizationRpcService orgOrganizationRpcService) {
        this.redisUtils = redisUtils;
        this.comSelectionRpcService = comSelectionRpcService;
        this.orgEmployeeRpcService = orgEmployeeRpcService;
        this.orgOrganizationRpcService = orgOrganizationRpcService;
    }
}

