/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.base.util;

import com.elitesland.tw.tw5.base.common.TwException;
import com.elitesland.tw.tw5.base.common.TwOutputUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.payload.ApprovePayload;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowUtil {
    private static final Logger log = LoggerFactory.getLogger(WorkflowUtil.class);
    private final WorkflowService workflowService;

    public TwOutputUtil<ProcessInfo> startProcess(StartProcessPayload payload) {
        try {
            WorkflowResult workflowResult = this.workflowService.startProcess(payload);
            System.out.println("workflowResult:::" + workflowResult.toString());
            if (workflowResult.isSuccess()) {
                return TwOutputUtil.ok((ProcessInfo)workflowResult.getData());
            }
            return TwOutputUtil.error("", "\u5de5\u4f5c\u6d41\u521b\u5efa\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        catch (Exception e) {
            log.error("openFeign\u5f02\u5e38={}", (Object)e.toString());
            return TwOutputUtil.error("", "\u672a\u6210\u529f\u521b\u5efa\u5de5\u4f5c\u6d41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
    }

    public TwOutputUtil deleteProcess(DeleteProcessPayload payload) {
        try {
            WorkflowResult workflowResult = this.workflowService.deleteProcess(payload);
            System.out.println("workflowResult:::" + workflowResult.toString());
            if (workflowResult.isSuccess()) {
                return TwOutputUtil.ok();
            }
            return TwOutputUtil.error("", "\u5de5\u4f5c\u6d41\u5220\u9664\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        catch (Exception e) {
            log.error("openFeign\u5f02\u5e38={}", (Object)e.toString());
            return TwOutputUtil.error("", "\u672a\u6210\u529f\u5220\u9664\u5de5\u4f5c\u6d41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
    }

    public TwOutputUtil setVariables(SetVariablesPayload payload) {
        try {
            WorkflowResult workflowResult = this.workflowService.setVariables(payload);
            System.out.println("workflowResult:::" + workflowResult.toString());
            if (workflowResult.isSuccess()) {
                return TwOutputUtil.ok();
            }
            return TwOutputUtil.error("", "\u5de5\u4f5c\u6d41\u4fee\u6539\u8282\u70b9\u5ba1\u6279\u4eba\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        catch (Exception e) {
            log.error("openFeign\u5f02\u5e38={}", (Object)e.toString());
            return TwOutputUtil.error("", "\u672a\u6210\u529f\u4fee\u6539\u8282\u70b9\u5ba1\u6279\u4eba\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
    }

    public TwOutputUtil approve(ApprovePayload payload) {
        try {
            WorkflowResult workflowResult = this.workflowService.approve(payload);
            System.out.println("workflowResult:::" + workflowResult.toString());
            if (workflowResult.isSuccess()) {
                return TwOutputUtil.ok();
            }
            return TwOutputUtil.error("", "\u5de5\u4f5c\u6d41\u63a8\u8fdb\u6d41\u7a0b\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        catch (Exception e) {
            throw TwException.error("", "\u672a\u6210\u529f\u63a8\u8fdb\u5de5\u4f5c\u6d41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
    }

    public TwOutputUtil<TaskInfo> currentTaskInfo(String procInstId) {
        try {
            WorkflowResult workflowResult = this.workflowService.currentTaskInfo(procInstId);
            System.out.println("workflowResult:::" + workflowResult.toString());
            if (workflowResult.isSuccess()) {
                return TwOutputUtil.ok((TaskInfo)workflowResult.getData());
            }
            return TwOutputUtil.error("", "\u5de5\u4f5c\u6d41\u63a8\u8fdb\u6d41\u7a0b\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        catch (Exception e) {
            throw TwException.error("", "\u5de5\u4f5c\u6d41\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
    }

    public WorkflowUtil(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }
}

