package com.elitescloud.cloudt.xyc.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 鲜易采供应商.
 *
 * @author Kaiser（wang shao）
 * @date 2025/2/16
 */
@Getter
@Setter
public class XycSupplierAccountDTO implements Serializable {
    private static final long serialVersionUID = -7286541254728283048L;

    /**
     * 密码
     */
    private String enPassword;

    /**
     * 登录账号
     */
    private String loginName;

    /**
     * 账号状态：1=正常 2=冻结  4=注销 5=待完善  6=临时
     */
    private Integer statusCd;

    /**
     * 显示名称
     */
    private String fullName;

    /**
     * 供应商ID
     */
    private String supplierId;

    /**
     * 是否需要重新登录
     */
    private Boolean needReset;

    public boolean isValid() {
        return this.statusCd != null && this.statusCd == 1;
    }
}
