package com.elitescloud.cloudt.xyc.rpc;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.xyc.dto.XycEmployeeSyncDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/2/16
 */
@FeignClient(name = Application.NAME, path = XycEmployeeRpcService.URI)
@Validated
public interface XycEmployeeRpcService {
    String URI = Application.URI_PREFIX + "/xycEmp";

    @PostMapping(value = "/save")
    ApiResult<Long> saveEmployee(@RequestBody XycEmployeeSyncDTO syncDTO);
}
