package com.elitescloud.cloudt.xyc.rpc;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.xyc.dto.ZbzzSysPageFieldConfigQueryDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = Application.NAME, path = ZbzzSysPageFieldConfigRpcService.URI)
@Validated
public interface ZbzzSysPageFieldConfigRpcService {
    String URI = Application.URI_PREFIX + "/sysPageFieldConfig";

    @PostMapping(value = "/rpcQueryByConfigCode")
    ApiResult<ZbzzSysPageFieldConfigQueryDTO> rpcQueryByConfigCode(@RequestParam(name = "configCode") String configCode);
}
