package com.elitescloud.cloudt.xyc.dto;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 员工同步信息.
 *
 * @author Kaiser（wang shao）
 * @date 2025/2/16
 */
@Getter
@Setter
public class XycEmployeeSyncDTO implements Serializable {
    private static final long serialVersionUID = 4656975106128301246L;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 员工名称
     */
    private String employeeName;

    /**
     * 员工编号
     */
    private String employeeNo;

    /**
     * 账号密码（密文）
     */
    private String enPassword;

    /**
     * 登录账号
     */
    private String loginName;

    /**
     * 手机号码
     */
    private String mobileNo;

    /**
     * 账号状态（1：可用， 0：禁用， 2：注销， 3：未配置）
     */
    private Integer statusCd;

    private List<Bu> departs;

    @Data
    public static class Bu {
        private String code;
        private String name;
    }

    public boolean isValid() {
        return this.statusCd != null && this.statusCd == 1;
    }
}
