package com.elitesland.yst.security.common;

import com.elitesland.yst.system.vo.SysTableVO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author james
 */
public class TableContext {

    private final static ThreadLocal<List<SysTableVO>> buTables = new ThreadLocal<>();

    public static void setTables(List<SysTableVO> tables) {
        buTables.set(tables);
    }

    public static List<SysTableVO> getTables() {
        return buTables.get();
    }

    public static void remove() {
        buTables.remove();
    }

    //存放用户对应的buId List
    private final static ThreadLocal<Map<String,List<Long>>> buIdMap = new ThreadLocal<>();

    public static void setBuIdMap(String userId,List<Long> buIdList){
        if(buIdMap.get()!=null){
            buIdMap.get().put(userId,buIdList);
        }else{
            Map<String,List<Long>> buMap=new HashMap<String,List<Long>>();
            buMap.put(userId,buIdList);
            buIdMap.set(buMap);
        }

    }

    public static List<Long> getBuidList(String userId){
        if(buIdMap.get()!=null){
            return buIdMap.get().get(userId);
        }else{
            return new ArrayList<Long>();
        }
        //return buIdMap.get().get(userId);
    }

    public static void removeBuidByUserid(String userId){
        if(buIdMap.get()!=null&&buIdMap.get().containsKey(userId)){
            buIdMap.get().remove(userId);
        }
    }

}
