/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.base;

import cn.hutool.core.util.StrUtil;
import com.elitesland.yst.common.base.ApiCode;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

public class ApiResult<T>
implements Serializable {
    private static final long serialVersionUID = 7722914707623525357L;
    private int code;
    private String msg;
    private String errorMsg;
    private boolean success;
    private T data;
    private LocalDateTime time;

    public ApiResult() {
    }

    public static <T> ApiResult<T> result(boolean bl) {
        if (bl) {
            return ApiResult.ok();
        }
        return ApiResult.fail();
    }

    public static <T> ApiResult<T> result(ApiCode apiCode) {
        return ApiResult.result(apiCode, null);
    }

    public static <T> ApiResult<T> result(ApiCode apiCode, T t) {
        return ApiResult.result(apiCode, null, t);
    }

    public static <T> ApiResult<T> result(ApiCode apiCode, String string, T t) {
        boolean bl = apiCode == ApiCode.SUCCESS;
        return ApiResult.builder().code(apiCode.getCode()).msg(StrUtil.isBlank((CharSequence)string) ? apiCode.getMsgFriendly() : string).errorMsg(apiCode.getMsg()).data(t).success(bl).time(LocalDateTime.now()).build();
    }

    public static <T> ApiResult<T> ok() {
        return ApiResult.ok(null);
    }

    public static <T> ApiResult<T> ok(T t) {
        return ApiResult.result(ApiCode.SUCCESS, t);
    }

    public static <T> ApiResult<T> ok(T t, String string) {
        return ApiResult.result(ApiCode.SUCCESS, string, t);
    }

    public static <T> ApiResult<Map<String, T>> okMap(String string, T t) {
        HashMap<String, T> hashMap = new HashMap<String, T>(1);
        hashMap.put(string, t);
        return ApiResult.ok(hashMap);
    }

    public static Map<String, Object> toMap(ApiResult<?> apiResult) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("code", apiResult.code);
        hashMap.put("msg", apiResult.msg);
        hashMap.put("data", apiResult.data);
        hashMap.put("success", apiResult.success);
        hashMap.put("time", apiResult.time);
        return hashMap;
    }

    public static <T> ApiResult<T> fail(ApiCode apiCode) {
        return ApiResult.result(apiCode, null);
    }

    public static <T> ApiResult<T> fail(String string) {
        return ApiResult.result(ApiCode.FAIL, string, null);
    }

    public static ApiResult<Object> fail(ApiCode apiCode, String string) {
        if (ApiCode.SUCCESS == apiCode) {
            throw new IllegalArgumentException("\u5931\u8d25\u7ed3\u679c\u72b6\u6001\u7801\u4e0d\u80fd\u4e3a" + ApiCode.SUCCESS.getCode());
        }
        return ApiResult.result(apiCode, string, null);
    }

    public static <T> ApiResult<T> fail(ApiCode apiCode, T t) {
        if (ApiCode.SUCCESS == apiCode) {
            throw new IllegalArgumentException("\u5931\u8d25\u7ed3\u679c\u72b6\u6001\u7801\u4e0d\u80fd\u4e3a" + ApiCode.SUCCESS.getCode());
        }
        return ApiResult.result(apiCode, t);
    }

    public static <T> ApiResult<T> fail(ApiCode apiCode, T t, String string) {
        if (ApiCode.SUCCESS == apiCode) {
            throw new IllegalArgumentException("\u5931\u8d25\u7ed3\u679c\u72b6\u6001\u7801\u4e0d\u80fd\u4e3a" + ApiCode.SUCCESS.getCode());
        }
        return ApiResult.result(apiCode, string, t);
    }

    public static <T> ApiResult<Map<String, T>> fail(String string, T t) {
        HashMap<String, T> hashMap = new HashMap<String, T>(1);
        hashMap.put(string, t);
        return ApiResult.result(ApiCode.FAIL, hashMap);
    }

    public static <T> ApiResult<T> fail() {
        return ApiResult.fail(ApiCode.FAIL);
    }

    private static <T> LocalDateTime $default$time() {
        return LocalDateTime.now();
    }

    public static <T> ApiResultBuilder<T> builder() {
        return new ApiResultBuilder();
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public T getData() {
        return this.data;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public ApiResult<T> setCode(int n) {
        this.code = n;
        return this;
    }

    public ApiResult<T> setMsg(String string) {
        this.msg = string;
        return this;
    }

    public ApiResult<T> setErrorMsg(String string) {
        this.errorMsg = string;
        return this;
    }

    public ApiResult<T> setSuccess(boolean bl) {
        this.success = bl;
        return this;
    }

    public ApiResult<T> setData(T t) {
        this.data = t;
        return this;
    }

    public ApiResult<T> setTime(LocalDateTime localDateTime) {
        this.time = localDateTime;
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ApiResult)) {
            return false;
        }
        ApiResult apiResult = (ApiResult)object;
        if (!apiResult.canEqual(this)) {
            return false;
        }
        if (this.getCode() != apiResult.getCode()) {
            return false;
        }
        if (this.isSuccess() != apiResult.isSuccess()) {
            return false;
        }
        String string = this.getMsg();
        String string2 = apiResult.getMsg();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getErrorMsg();
        String string4 = apiResult.getErrorMsg();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        T t = this.getData();
        T t2 = apiResult.getData();
        if (t == null ? t2 != null : !t.equals(t2)) {
            return false;
        }
        LocalDateTime localDateTime = this.getTime();
        LocalDateTime localDateTime2 = apiResult.getTime();
        return !(localDateTime == null ? localDateTime2 != null : !((Object)localDateTime).equals(localDateTime2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof ApiResult;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + this.getCode();
        n2 = n2 * 59 + (this.isSuccess() ? 79 : 97);
        String string = this.getMsg();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getErrorMsg();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        T t = this.getData();
        n2 = n2 * 59 + (t == null ? 43 : t.hashCode());
        LocalDateTime localDateTime = this.getTime();
        n2 = n2 * 59 + (localDateTime == null ? 43 : ((Object)localDateTime).hashCode());
        return n2;
    }

    public String toString() {
        return "ApiResult(code=" + this.getCode() + ", msg=" + this.getMsg() + ", errorMsg=" + this.getErrorMsg() + ", success=" + this.isSuccess() + ", data=" + this.getData() + ", time=" + this.getTime() + ")";
    }

    public ApiResult(int n, String string, String string2, boolean bl, T t, LocalDateTime localDateTime) {
        this.code = n;
        this.msg = string;
        this.errorMsg = string2;
        this.success = bl;
        this.data = t;
        this.time = localDateTime;
    }

    public static class ApiResultBuilder<T> {
        private int a;
        private String b;
        private String c;
        private boolean d;
        private T e;
        private boolean f;
        private LocalDateTime g;

        ApiResultBuilder() {
        }

        public ApiResultBuilder<T> code(int n) {
            this.a = n;
            return this;
        }

        public ApiResultBuilder<T> msg(String string) {
            this.b = string;
            return this;
        }

        public ApiResultBuilder<T> errorMsg(String string) {
            this.c = string;
            return this;
        }

        public ApiResultBuilder<T> success(boolean bl) {
            this.d = bl;
            return this;
        }

        public ApiResultBuilder<T> data(T t) {
            this.e = t;
            return this;
        }

        public ApiResultBuilder<T> time(LocalDateTime localDateTime) {
            this.g = localDateTime;
            this.f = true;
            return this;
        }

        public ApiResult<T> build() {
            LocalDateTime localDateTime = this.g;
            if (!this.f) {
                localDateTime = ApiResult.$default$time();
            }
            return new ApiResult<T>(this.a, this.b, this.c, this.d, this.e, localDateTime);
        }

        public String toString() {
            return "ApiResult.ApiResultBuilder(code=" + this.a + ", msg=" + this.b + ", errorMsg=" + this.c + ", success=" + this.d + ", data=" + this.e + ", time$value=" + this.g + ")";
        }
    }
}

