/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Component;

@Component
public class RedisUtils {
    private static final Logger log = LoggerFactory.getLogger(RedisUtils.class);
    private RedisTemplate<Object, Object> a;

    public RedisUtils(RedisTemplate<Object, Object> redisTemplate) {
        this.a = redisTemplate;
    }

    public boolean expire(String string, long l) {
        try {
            if (l > 0L) {
                this.a.expire((Object)string, l, TimeUnit.SECONDS);
            }
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
        return true;
    }

    public boolean expire(String string, long l, TimeUnit timeUnit) {
        try {
            if (l > 0L) {
                this.a.expire((Object)string, l, timeUnit);
            }
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
        return true;
    }

    public long getExpire(Object object) {
        return this.a.getExpire(object, TimeUnit.SECONDS);
    }

    public List<String> scan(String string) {
        ScanOptions scanOptions = ScanOptions.scanOptions().match(string).build();
        RedisConnectionFactory redisConnectionFactory = this.a.getConnectionFactory();
        RedisConnection redisConnection = Objects.requireNonNull(redisConnectionFactory).getConnection();
        Cursor cursor = redisConnection.scan(scanOptions);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (cursor.hasNext()) {
            arrayList.add(new String((byte[])cursor.next()));
        }
        try {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)redisConnectionFactory);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
        return arrayList;
    }

    public List<String> findKeysForPage(String string, int n, int n2) {
        ScanOptions scanOptions = ScanOptions.scanOptions().match(string).build();
        RedisConnectionFactory redisConnectionFactory = this.a.getConnectionFactory();
        RedisConnection redisConnection = Objects.requireNonNull(redisConnectionFactory).getConnection();
        Cursor cursor = redisConnection.scan(scanOptions);
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        int n3 = 0;
        int n4 = n * n2;
        int n5 = n * n2 + n2;
        while (cursor.hasNext()) {
            if (n3 >= n4 && n3 < n5) {
                arrayList.add(new String((byte[])cursor.next()));
                ++n3;
                continue;
            }
            if (n3 >= n5) break;
            ++n3;
            cursor.next();
        }
        try {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)redisConnectionFactory);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
        return arrayList;
    }

    public boolean hasKey(String string) {
        try {
            return this.a.hasKey((Object)string);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public void del(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            if (stringArray.length == 1) {
                boolean bl = this.a.delete((Object)stringArray[0]);
                System.out.println("--------------------------------------------");
                System.out.println(new StringBuilder("\u5220\u9664\u7f13\u5b58\uff1a").append(stringArray[0]).append("\uff0c\u7ed3\u679c\uff1a").append(bl));
                System.out.println("--------------------------------------------");
            } else {
                HashSet hashSet = new HashSet();
                for (String string : stringArray) {
                    hashSet.addAll(this.a.keys((Object)string));
                }
                long l = this.a.delete(hashSet);
                System.out.println("--------------------------------------------");
                System.out.println("\u6210\u529f\u5220\u9664\u7f13\u5b58\uff1a" + ((Object)hashSet).toString());
                System.out.println("\u7f13\u5b58\u5220\u9664\u6570\u91cf\uff1a" + l + "\u4e2a");
                System.out.println("--------------------------------------------");
            }
        }
    }

    public Object get(String string) {
        return string == null ? null : this.a.opsForValue().get((Object)string);
    }

    public List<Object> multiGet(List<String> list) {
        List list2 = this.a.opsForValue().multiGet(Collections.singleton(list));
        return null;
    }

    public boolean set(String string, Object object) {
        try {
            this.a.opsForValue().set((Object)string, object);
            return true;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public boolean set(String string, Object object, long l) {
        try {
            if (l > 0L) {
                this.a.opsForValue().set((Object)string, object, l, TimeUnit.SECONDS);
            } else {
                this.set(string, object);
            }
            return true;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public boolean set(String string, Object object, long l, TimeUnit timeUnit) {
        try {
            if (l > 0L) {
                this.a.opsForValue().set((Object)string, object, l, timeUnit);
            } else {
                this.set(string, object);
            }
            return true;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public Object hget(String string, String string2) {
        return this.a.opsForHash().get((Object)string, (Object)string2);
    }

    public Map<Object, Object> hmget(String string) {
        return this.a.opsForHash().entries((Object)string);
    }

    public boolean hmset(String string, Map<String, Object> map) {
        try {
            this.a.opsForHash().putAll((Object)string, map);
            return true;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public boolean hmset(String string, Map<String, Object> map, long l) {
        try {
            this.a.opsForHash().putAll((Object)string, map);
            if (l > 0L) {
                this.expire(string, l);
            }
            return true;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public boolean hset(String string, String string2, Object object) {
        try {
            this.a.opsForHash().put((Object)string, (Object)string2, object);
            return true;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public boolean hset(String string, String string2, Object object, long l) {
        try {
            this.a.opsForHash().put((Object)string, (Object)string2, object);
            if (l > 0L) {
                this.expire(string, l);
            }
            return true;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public void hdel(String string, Object ... objectArray) {
        this.a.opsForHash().delete((Object)string, objectArray);
    }

    public boolean hHasKey(String string, String string2) {
        return this.a.opsForHash().hasKey((Object)string, (Object)string2);
    }

    public double hincr(String string, String string2, double d) {
        return this.a.opsForHash().increment((Object)string, (Object)string2, d);
    }

    public double hdecr(String string, String string2, double d) {
        return this.a.opsForHash().increment((Object)string, (Object)string2, -d);
    }

    public Set<Object> sGet(String string) {
        try {
            return this.a.opsForSet().members((Object)string);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public boolean sHasKey(String string, Object object) {
        try {
            return this.a.opsForSet().isMember((Object)string, object);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public long sSet(String string, Object ... objectArray) {
        try {
            return this.a.opsForSet().add((Object)string, objectArray);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return 0L;
        }
    }

    public long sSetAndTime(String string, long l, Object ... objectArray) {
        try {
            Long l2 = this.a.opsForSet().add((Object)string, objectArray);
            if (l > 0L) {
                this.expire(string, l);
            }
            return l2;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return 0L;
        }
    }

    public long sGetSetSize(String string) {
        try {
            return this.a.opsForSet().size((Object)string);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return 0L;
        }
    }

    public long setRemove(String string, Object ... objectArray) {
        try {
            Long l = this.a.opsForSet().remove((Object)string, objectArray);
            return l;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return 0L;
        }
    }

    public List<Object> lGet(String string, long l, long l2) {
        try {
            return this.a.opsForList().range((Object)string, l, l2);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public long lGetListSize(String string) {
        try {
            return this.a.opsForList().size((Object)string);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return 0L;
        }
    }

    public Object lGetIndex(String string, long l) {
        try {
            return this.a.opsForList().index((Object)string, l);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public boolean lSet(String string, Object object) {
        try {
            this.a.opsForList().rightPush((Object)string, object);
            return true;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public boolean lSet(String string, Object object, long l) {
        try {
            this.a.opsForList().rightPush((Object)string, object);
            if (l > 0L) {
                this.expire(string, l);
            }
            return true;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public boolean lSet(String string, List<Object> list) {
        try {
            this.a.opsForList().rightPushAll((Object)string, list);
            return true;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public boolean lSet(String string, List<Object> list, long l) {
        try {
            this.a.opsForList().rightPushAll((Object)string, list);
            if (l > 0L) {
                this.expire(string, l);
            }
            return true;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public boolean lUpdateIndex(String string, long l, Object object) {
        try {
            this.a.opsForList().set((Object)string, l, object);
            return true;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public long lRemove(String string, long l, Object object) {
        try {
            return this.a.opsForList().remove((Object)string, l, object);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return 0L;
        }
    }

    public void delByKeys(String string, Set<Long> set) {
        HashSet hashSet = new HashSet();
        for (Long l : set) {
            hashSet.addAll(this.a.keys((Object)new StringBuffer(string).append(l).toString()));
        }
        long l = this.a.delete(hashSet);
        System.out.println("--------------------------------------------");
        System.out.println("\u6210\u529f\u5220\u9664\u7f13\u5b58\uff1a" + ((Object)hashSet).toString());
        System.out.println("\u7f13\u5b58\u5220\u9664\u6570\u91cf\uff1a" + l + "\u4e2a");
        System.out.println("--------------------------------------------");
    }
}

