/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.util;

import com.elitesland.yst.common.util.CallBack;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;

public class SpringContextHolder
implements DisposableBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringContextHolder.class);
    private static ApplicationContext applicationContext = null;
    private static final List<CallBack> CALL_BACKS = new ArrayList<CallBack>();
    private static boolean addCallback = true;

    public static synchronized void addCallBacks(CallBack callBack) {
        if (addCallback) {
            CALL_BACKS.add(callBack);
        } else {
            log.warn("CallBack\uff1a{} \u5df2\u65e0\u6cd5\u6dfb\u52a0\uff01\u7acb\u5373\u6267\u884c", (Object)callBack.getCallBackName());
            callBack.executor();
        }
    }

    public static <T> T getBean(String string) {
        SpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(string);
    }

    public static <T> T getBean(Class<T> clazz) {
        SpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(clazz);
    }

    public static <T> T getProperties(String string, T t, Class<T> clazz) {
        Object object = t;
        try {
            object = SpringContextHolder.getBean(Environment.class).getProperty(string, clazz);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public static String getProperties(String string) {
        return SpringContextHolder.getProperties(string, null, String.class);
    }

    public static <T> T getProperties(String string, Class<T> clazz) {
        return SpringContextHolder.getProperties(string, null, clazz);
    }

    private static void assertContextInjected() {
        if (applicationContext == null) {
            throw new IllegalStateException("applicaitonContext\u5c5e\u6027\u672a\u6ce8\u5165, \u8bf7\u5728applicationContext.xml\u4e2d\u5b9a\u4e49SpringContextHolder\u6216\u5728SpringBoot\u542f\u52a8\u7c7b\u4e2d\u6ce8\u518cSpringContextHolder.");
        }
    }

    private static void clearHolder() {
        log.debug("\u6e05\u9664SpringContextHolder\u4e2d\u7684ApplicationContext:" + applicationContext);
        applicationContext = null;
    }

    public void destroy() {
        SpringContextHolder.clearHolder();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (SpringContextHolder.applicationContext != null) {
            log.warn("SpringContextHolder\u4e2d\u7684ApplicationContext\u88ab\u8986\u76d6, \u539f\u6709ApplicationContext\u4e3a:" + SpringContextHolder.applicationContext);
        }
        SpringContextHolder.applicationContext = applicationContext;
        if (addCallback) {
            for (CallBack callBack : CALL_BACKS) {
                callBack.executor();
            }
            CALL_BACKS.clear();
        }
        addCallback = false;
    }
}

