/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.annotations.HCANNHelper;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

class PropertyContainer {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)PropertyContainer.class.getName());
    private final XClass xClass;
    private final XClass entityAtStake;
    private final AccessType classLevelAccessType;
    private final LinkedHashMap<String, XProperty> persistentAttributeMap;

    PropertyContainer(XClass xClass, XClass xClass2, AccessType accessType) {
        this.xClass = xClass;
        this.entityAtStake = xClass2;
        if (accessType == AccessType.DEFAULT) {
            accessType = AccessType.PROPERTY;
        }
        AccessType accessType2 = this.determineLocalClassDefinedAccessStrategy();
        assert (accessType2 != null);
        AccessType accessType3 = this.classLevelAccessType = accessType2 != AccessType.DEFAULT ? accessType2 : accessType;
        assert (this.classLevelAccessType == AccessType.FIELD || this.classLevelAccessType == AccessType.PROPERTY);
        this.persistentAttributeMap = new LinkedHashMap();
        List list = this.xClass.getDeclaredProperties(AccessType.FIELD.getType());
        List list2 = this.xClass.getDeclaredProperties(AccessType.PROPERTY.getType());
        this.preFilter(list, list2);
        HashMap<String, XProperty> hashMap = new HashMap<String, XProperty>();
        this.collectPersistentAttributesUsingLocalAccessType(this.persistentAttributeMap, hashMap, list, list2);
        this.collectPersistentAttributesUsingClassLevelAccessType(this.persistentAttributeMap, hashMap, list, list2);
    }

    private void preFilter(List<XProperty> list, List<XProperty> list2) {
        XProperty xProperty;
        Iterator<XProperty> iterator = list.iterator();
        while (iterator.hasNext()) {
            xProperty = iterator.next();
            if (!PropertyContainer.mustBeSkipped(xProperty)) continue;
            iterator.remove();
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            xProperty = iterator.next();
            if (!PropertyContainer.mustBeSkipped(xProperty)) continue;
            iterator.remove();
        }
    }

    private void collectPersistentAttributesUsingLocalAccessType(LinkedHashMap<String, XProperty> linkedHashMap, Map<String, XProperty> map, List<XProperty> list, List<XProperty> list2) {
        Access access;
        XProperty xProperty;
        Iterator<XProperty> iterator = list.iterator();
        while (iterator.hasNext()) {
            xProperty = iterator.next();
            access = (Access)xProperty.getAnnotation(Access.class);
            if (access == null || access.value() != javax.persistence.AccessType.FIELD) continue;
            iterator.remove();
            linkedHashMap.put(xProperty.getName(), xProperty);
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            xProperty = iterator.next();
            access = (Access)xProperty.getAnnotation(Access.class);
            if (access == null || access.value() != javax.persistence.AccessType.PROPERTY) continue;
            iterator.remove();
            String string = xProperty.getName();
            XProperty xProperty2 = map.get(string);
            if (xProperty2 != null) {
                throw new org.hibernate.boot.MappingException(LOG.ambiguousPropertyMethods(this.xClass.getName(), HCANNHelper.annotatedElementSignature((XProperty)xProperty2), HCANNHelper.annotatedElementSignature((XProperty)xProperty)), new Origin(SourceType.ANNOTATION, this.xClass.getName()));
            }
            linkedHashMap.put(string, xProperty);
            map.put(string, xProperty);
        }
    }

    private void collectPersistentAttributesUsingClassLevelAccessType(LinkedHashMap<String, XProperty> linkedHashMap, Map<String, XProperty> map, List<XProperty> list, List<XProperty> list2) {
        if (this.classLevelAccessType == AccessType.FIELD) {
            for (XProperty xProperty : list) {
                if (linkedHashMap.containsKey(xProperty.getName())) continue;
                linkedHashMap.put(xProperty.getName(), xProperty);
            }
        } else {
            for (XProperty xProperty : list2) {
                String string = xProperty.getName();
                XProperty xProperty2 = map.get(string);
                if (xProperty2 != null) {
                    throw new org.hibernate.boot.MappingException(LOG.ambiguousPropertyMethods(this.xClass.getName(), HCANNHelper.annotatedElementSignature((XProperty)xProperty2), HCANNHelper.annotatedElementSignature((XProperty)xProperty)), new Origin(SourceType.ANNOTATION, this.xClass.getName()));
                }
                if (linkedHashMap.containsKey(string)) continue;
                linkedHashMap.put(xProperty.getName(), xProperty);
                map.put(string, xProperty);
            }
        }
    }

    public XClass getEntityAtStake() {
        return this.entityAtStake;
    }

    public XClass getDeclaringClass() {
        return this.xClass;
    }

    public AccessType getClassLevelAccessType() {
        return this.classLevelAccessType;
    }

    public Collection<XProperty> getProperties() {
        this.assertTypesAreResolvable();
        return Collections.unmodifiableCollection(this.persistentAttributeMap.values());
    }

    private void assertTypesAreResolvable() {
        for (XProperty xProperty : this.persistentAttributeMap.values()) {
            if (xProperty.isTypeResolved() || PropertyContainer.discoverTypeWithoutReflection(xProperty)) continue;
            String string = "Property " + StringHelper.qualify((String)this.xClass.getName(), (String)xProperty.getName()) + " has an unbound type and no explicit target entity. Resolve this Generic usage issue or set an explicit target attribute (eg @OneToMany(target=) or use an explicit @Type";
            throw new AnnotationException(string);
        }
    }

    private AccessType determineLocalClassDefinedAccessStrategy() {
        Access access;
        AccessType accessType = AccessType.DEFAULT;
        AccessType accessType2 = AccessType.DEFAULT;
        org.hibernate.annotations.AccessType accessType3 = (org.hibernate.annotations.AccessType)this.xClass.getAnnotation(org.hibernate.annotations.AccessType.class);
        if (accessType3 != null) {
            accessType = AccessType.getAccessStrategy((String)accessType3.value());
        }
        if ((access = (Access)this.xClass.getAnnotation(Access.class)) != null) {
            accessType2 = AccessType.getAccessStrategy((javax.persistence.AccessType)access.value());
        }
        if (accessType != AccessType.DEFAULT && accessType2 != AccessType.DEFAULT && accessType != accessType2) {
            throw new MappingException("@AccessType and @Access specified with contradicting values. Use of @Access only is recommended. ");
        }
        AccessType accessType4 = accessType != AccessType.DEFAULT ? accessType : accessType2;
        return accessType4;
    }

    private static boolean discoverTypeWithoutReflection(XProperty xProperty) {
        if (xProperty.isAnnotationPresent(OneToOne.class) && !((OneToOne)xProperty.getAnnotation(OneToOne.class)).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (xProperty.isAnnotationPresent(OneToMany.class) && !((OneToMany)xProperty.getAnnotation(OneToMany.class)).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (xProperty.isAnnotationPresent(ManyToOne.class) && !((ManyToOne)xProperty.getAnnotation(ManyToOne.class)).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (xProperty.isAnnotationPresent(ManyToMany.class) && !((ManyToMany)xProperty.getAnnotation(ManyToMany.class)).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (xProperty.isAnnotationPresent(Any.class)) {
            return true;
        }
        if (xProperty.isAnnotationPresent(ManyToAny.class)) {
            if (!xProperty.isCollection() && !xProperty.isArray()) {
                throw new AnnotationException("@ManyToAny used on a non collection non array property: " + xProperty.getName());
            }
            return true;
        }
        if (xProperty.isAnnotationPresent(Type.class)) {
            return true;
        }
        return xProperty.isAnnotationPresent(Target.class);
    }

    private static boolean mustBeSkipped(XProperty xProperty) {
        return xProperty.isAnnotationPresent(Transient.class) || "net.sf.cglib.transform.impl.InterceptFieldCallback".equals(xProperty.getType().getName()) || "org.hibernate.bytecode.internal.javassist.FieldHandler".equals(xProperty.getType().getName());
    }
}

