/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.base.param;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.param.QueryParam;
import com.elitesland.yst.common.exception.BusinessException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.PathBuilderValidator;
import com.querydsl.jpa.impl.JPAQuery;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

@ApiModel(value="\u53ef\u6392\u5e8f\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61")
public abstract class AbstractOrderQueryParam
extends QueryParam {
    private static final long serialVersionUID = 57714391204790143L;
    @ApiModelProperty(value="\u6392\u5e8f")
    private List<OrderItem> orders;

    public List<OrderItem> getOrders() {
        return this.orders;
    }

    public void setOrders(List<OrderItem> list) {
        this.orders = list;
    }

    public void defaultOrder(OrderItem orderItem) {
        this.defaultOrders(Collections.singletonList(orderItem));
    }

    public void defaultOrders(List<OrderItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.orders = list;
    }

    @JsonIgnore
    public PageRequest getPageRequest() {
        ArrayList arrayList = CollectionUtils.isEmpty(this.orders) ? new ArrayList() : this.orders.stream().map(orderItem -> new Sort.Order(orderItem.isAsc() ? Sort.Direction.ASC : Sort.Direction.DESC, orderItem.getColumn())).collect(Collectors.toList());
        return PageRequest.of((int)this.getCurrent(), (int)this.getSize(), (Sort)Sort.by(arrayList));
    }

    @JsonIgnore
    public void fillOrders(JPAQuery<?> jPAQuery, EntityPathBase entityPathBase) {
        PageRequest pageRequest = this.getPageRequest();
        PathBuilder pathBuilder = new PathBuilder(entityPathBase.getClass(), entityPathBase.getMetadata(), PathBuilderValidator.FIELDS);
        pageRequest.getSort().forEach(order -> jPAQuery.orderBy(new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, (Expression)pathBuilder.get(order.getProperty()))));
    }

    @JsonIgnore
    public void fillOrders(JPAQuery<?> jPAQuery) {
        PageRequest pageRequest = this.getPageRequest();
        pageRequest.getSort().forEach(order -> {
            String[] stringArray = order.getProperty().split("\\.");
            if (stringArray.length <= 1) {
                throw new BusinessException(ApiCode.PARAMETER_PARSE_EXCEPTION, "\u6392\u5e8f\u5b57\u6bb5\u9700\u8981\u6307\u5b9a\u6240\u5c5ehql\u7684\u5b9e\u4f53\u5bf9\u8c61\uff0c\u5bf9\u8c61\u540d\u79f0.\u5b57\u6bb5\u540d\u79f0");
            }
            PathBuilder pathBuilder = new PathBuilder(Object.class, stringArray[0]);
            jPAQuery.orderBy(new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, (Expression)pathBuilder.get(stringArray[1])));
        });
    }

    @JsonIgnore
    public void setPaging(JPAQuery<?> jPAQuery) {
        jPAQuery.offset((long)(this.getCurrent() * this.getSize()));
        jPAQuery.limit((long)this.getSize().intValue());
    }

    @Override
    public String toString() {
        return "AbstractOrderQueryParam(orders=" + this.getOrders() + ")";
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractOrderQueryParam)) {
            return false;
        }
        AbstractOrderQueryParam abstractOrderQueryParam = (AbstractOrderQueryParam)object;
        if (!abstractOrderQueryParam.canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        List<OrderItem> list = this.getOrders();
        List<OrderItem> list2 = abstractOrderQueryParam.getOrders();
        return !(list == null ? list2 != null : !((Object)list).equals(list2));
    }

    @Override
    protected boolean canEqual(Object object) {
        return object instanceof AbstractOrderQueryParam;
    }

    @Override
    public int hashCode() {
        int n = 59;
        int n2 = super.hashCode();
        List<OrderItem> list = this.getOrders();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        return n2;
    }
}

