/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.config;

import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;
import org.redisson.api.RedissonClient;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.cache.CacheConfigSupport;
import org.redisson.spring.cache.RedissonSpringCacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
public class CacheRedisConfig
extends CacheConfigSupport {
    @Value(value="${redis.prefix:#{''}}")
    private String a;

    @Bean
    public KeyGenerator permissionRoleKeyGenerator() {
        return (object, method, objectArray) -> "sys_all_permissions_roles";
    }

    @Bean
    @Primary
    @Autowired
    public CacheManager redisCacheManager(RedisConnectionFactory redisConnectionFactory) {
        return new RedisCacheManager(RedisCacheWriter.lockingRedisCacheWriter((RedisConnectionFactory)redisConnectionFactory), RedisCacheConfiguration.defaultCacheConfig().disableCachingNullValues().prefixCacheNameWith(this.a));
    }

    @Bean
    @Autowired
    public CacheManager redissonManager(RedissonClient redissonClient) {
        HashedMap hashedMap = new HashedMap();
        hashedMap.put((Object)(this.a + "longCache"), (Object)new CacheConfig(180000L, 120000L));
        hashedMap.put((Object)(this.a + "shortCache"), (Object)new CacheConfig(60000L, 30000L));
        return new RedissonSpringCacheManager(redissonClient, (Map)hashedMap);
    }
}

