/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.config;

import cn.hutool.core.util.StrUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.redisson.config.TransportMode;
import org.redisson.spring.data.connection.RedissonConnectionFactory;
import org.redisson.spring.starter.RedissonAutoConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration
@AutoConfigureBefore(value={RedisAutoConfiguration.class, RedissonAutoConfiguration.class})
@ConditionalOnClass(value={Redisson.class, RedisOperations.class})
public class RedissonConfig {
    private static final Logger log = LoggerFactory.getLogger(RedissonConfig.class);
    @Value(value="${redis.redisson-cluster-config.nodes:#{null}}")
    private String a;
    @Value(value="${redis.redisson-cluster-config.password:#{null}}")
    private String b;
    @Value(value="${redis.redlock-instance-config.database:#{0}}")
    private int c;
    @Value(value="${redis.redlock-instance-config.node0.host:#{null}}")
    private String d;
    @Value(value="${redis.redlock-instance-config.node0.password:#{null}}")
    private String e;
    @Value(value="${redis.redlock-instance-config.node1.host:#{null}}")
    private String f;
    @Value(value="${redis.redlock-instance-config.node1.password:#{null}}")
    private String g;
    @Value(value="${redis.redlock-instance-config.node2.host:#{null}}")
    private String h;
    @Value(value="${redis.redlock-instance-config.node2.password:#{null}}")
    private String i;
    @Value(value="${redis.prefix:#{''}}")
    private String j;

    @Primary
    @Bean(value={"cluster_redis_client"})
    @ConditionalOnProperty(prefix="redis.redisson-cluster-config", name={"enabled"}, havingValue="true")
    public RedissonClient initRedissonClient() {
        if (StrUtil.isBlank((CharSequence)this.a)) {
            log.warn("\u52a0\u8f7dredission\u914d\u7f6e\u5931\u8d25");
            return Redisson.create();
        }
        Config config = new Config();
        config.setTransportMode(TransportMode.NIO);
        ((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)config.useClusterServers().addNodeAddress((String[])Arrays.stream(this.a.split(",")).map(String::strip).toArray(String[]::new)).setPassword(this.b)).setScanInterval(3000).setSubscriptionConnectionPoolSize(25)).setSlaveConnectionMinimumIdleSize(16)).setSlaveConnectionPoolSize(32)).setMasterConnectionMinimumIdleSize(16)).setMasterConnectionPoolSize(32)).setConnectTimeout(20000)).setTimeout(5000)).setRetryInterval(3000);
        return Redisson.create((Config)config);
    }

    @Bean(value={"redis_single_client0"})
    @ConditionalOnProperty(prefix="redis.redlock-instance-config", name={"enabled"}, havingValue="true")
    public RedissonClient initRedissonClientSingle0() {
        if (StrUtil.isBlank((CharSequence)this.d)) {
            log.warn("\u52a0\u8f7dredission\u914d\u7f6enode0\u5931\u8d25");
            return Redisson.create();
        }
        Config config = new Config();
        ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(this.d).setPassword(this.e)).setSubscriptionConnectionPoolSize(25).setConnectionMinimumIdleSize(16).setConnectionPoolSize(32).setConnectTimeout(20000)).setTimeout(5000)).setRetryInterval(3000)).setDatabase(this.c);
        return Redisson.create((Config)config);
    }

    @Bean(value={"redis_single_client1"})
    @ConditionalOnProperty(prefix="redis.redlock-instance-config", name={"enabled"}, havingValue="true")
    public RedissonClient initRedissonClientSingle1() {
        if (StrUtil.isBlank((CharSequence)this.f)) {
            log.warn("\u52a0\u8f7dredission\u914d\u7f6enode1\u5931\u8d25");
            return Redisson.create();
        }
        Config config = new Config();
        ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(this.f).setPassword(this.g)).setSubscriptionConnectionPoolSize(25).setConnectionMinimumIdleSize(16).setConnectionPoolSize(32).setConnectTimeout(20000)).setTimeout(5000)).setRetryInterval(3000)).setDatabase(this.c);
        return Redisson.create((Config)config);
    }

    @Bean(value={"redis_single_client2"})
    @ConditionalOnProperty(prefix="redis.redlock-instance-config", name={"enabled"}, havingValue="true")
    public RedissonClient initRedissonClientSingle2() {
        if (StrUtil.isBlank((CharSequence)this.f)) {
            log.warn("\u52a0\u8f7dredission\u914d\u7f6enode2\u5931\u8d25");
            return Redisson.create();
        }
        Config config = new Config();
        ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(this.h).setPassword(this.i)).setSubscriptionConnectionPoolSize(25).setConnectionMinimumIdleSize(16).setConnectionPoolSize(32).setConnectTimeout(20000)).setTimeout(5000)).setRetryInterval(3000)).setDatabase(this.c);
        return Redisson.create((Config)config);
    }

    @Bean
    @ConditionalOnProperty(prefix="redis.redisson-cluster-config", name={"enabled"}, havingValue="true")
    public RedisConnectionFactory initRedissonConnectionFactory(@Qualifier(value="cluster_redis_client") RedissonClient redissonClient) {
        return new RedissonConnectionFactory(redissonClient);
    }

    @Bean
    public RedisTemplate redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        RedisSerializer<String> redisSerializer = this.a();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        redisTemplate.setKeySerializer(redisSerializer);
        redisTemplate.setHashKeySerializer(redisSerializer);
        redisTemplate.setValueSerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        redisTemplate.setHashValueSerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        return redisTemplate;
    }

    private RedisSerializer<String> a() {
        return new RedisSerializer<String>(){
            private final Charset b = StandardCharsets.UTF_8;

            public String deserialize(byte[] byArray) {
                if (byArray == null) {
                    return null;
                }
                String string = new String(byArray, this.b);
                if (string.startsWith(RedissonConfig.this.j)) {
                    string = string.substring(RedissonConfig.this.j.length());
                }
                return string;
            }

            public byte[] serialize(String string) {
                String string2 = RedissonConfig.this.j + string;
                return string == null ? null : string2.getBytes(this.b);
            }
        };
    }
}

