/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.micro;

import com.elitesland.yst.common.micro.ClockPool;
import java.net.InetAddress;
import java.util.concurrent.ThreadLocalRandom;

public class Snowflake {
    private static final long START_TIME = 1519740777809L;
    private static final long DATA_CENTER_ID_BITS = 2L;
    private static final long WORKER_ID_BITS = 8L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long MAX_WORKER_ID = 255L;
    private static final long MAX_DATA_CENTER_ID = 3L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 20L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private final long a;
    private final long b;
    private long c = 0L;
    private long d = -1L;
    private static byte LAST_IP = 0;
    private final boolean e;
    private final long f;
    private final boolean g;
    private final ThreadLocalRandom h = ThreadLocalRandom.current();

    public Snowflake(long l) {
        this(l, 0xFF & Snowflake.getLastIPAddress(), false, 5L, false);
    }

    public Snowflake(long l, boolean bl, boolean bl2) {
        this(l, 0xFF & Snowflake.getLastIPAddress(), bl, 5L, bl2);
    }

    public Snowflake(long l, long l2, boolean bl, long l3, boolean bl2) {
        if (l > 3L || l < 0L) {
            throw new IllegalArgumentException("Data Center Id can't be greater than 3 or less than 0");
        }
        if (l2 > 255L || l2 < 0L) {
            throw new IllegalArgumentException("Worker Id can't be greater than 255 or less than 0");
        }
        this.a = l2;
        this.b = l;
        this.e = bl;
        this.f = l3;
        this.g = bl2;
    }

    public synchronized Long nextId() {
        long l;
        long l2 = this.a();
        if (l2 < this.d) {
            l = this.d - l2;
            if (l > this.f) {
                throw new RuntimeException("Clock moved backwards, refusing to generate id for [" + l + "ms]");
            }
            try {
                this.wait(l << 1);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            l2 = this.a();
            if (l2 < this.d) {
                throw new RuntimeException("Clock moved backwards, refusing to generate id for [" + l + "ms]");
            }
        }
        if (this.d == l2) {
            l = this.c + 1L;
            if (this.g && l > 4095L) {
                l %= 4095L;
            }
            this.c = l & 0xFFFL;
            if (this.c == 0L) {
                l2 = this.a(this.d);
            }
        } else {
            this.c = this.g ? this.h.nextLong(4096L) : 0L;
        }
        this.d = l2;
        l = l2 - 1519740777809L;
        return l << 22 | this.b << 20 | this.a << 12 | this.c;
    }

    private long a(long l) {
        long l2 = this.a();
        while (l2 <= l) {
            l2 = this.a();
        }
        return l2;
    }

    private long a() {
        return this.e ? ClockPool.INSTANCE.currentTimeMillis() : System.currentTimeMillis();
    }

    private static byte getLastIPAddress() {
        if (LAST_IP != 0) {
            return LAST_IP;
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            byte[] byArray = inetAddress.getAddress();
            LAST_IP = byArray[byArray.length - 1];
        }
        catch (Exception exception) {
            throw new RuntimeException("Unknown Host Exception", exception);
        }
        return LAST_IP;
    }
}

