/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.property;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.captcha.CaptchaUtil;
import com.elitesland.yst.common.exception.BadConfigurationException;
import com.elitesland.yst.common.property.CaptchaCodeEnum;
import com.elitesland.yst.common.property.CaptchaInfo;
import com.wf.captcha.ArithmeticCaptcha;
import com.wf.captcha.ChineseCaptcha;
import com.wf.captcha.ChineseGifCaptcha;
import com.wf.captcha.GifCaptcha;
import com.wf.captcha.SpecCaptcha;
import com.wf.captcha.base.Captcha;
import java.util.Objects;

public class LoginProperties {
    private Boolean a;
    private Boolean b;
    private CaptchaInfo c;

    public AbstractCaptcha getCaptchaHu() {
        if (Objects.isNull(this.c)) {
            return null;
        }
        if (this.c.getCodeType() == CaptchaCodeEnum.line || this.c.getCodeType() == CaptchaCodeEnum.circle || this.c.getCodeType() == CaptchaCodeEnum.shear) {
            switch (this.c.getCodeType()) {
                case line: {
                    return CaptchaUtil.createLineCaptcha((int)this.c.getWidth(), (int)this.c.getHeight());
                }
                case circle: {
                    return CaptchaUtil.createCircleCaptcha((int)this.c.getWidth(), (int)this.c.getHeight());
                }
            }
            return CaptchaUtil.createShearCaptcha((int)this.c.getWidth(), (int)this.c.getHeight());
        }
        return null;
    }

    public Captcha getCaptcha() {
        if (Objects.isNull(this.c)) {
            this.c = new CaptchaInfo();
            if (Objects.isNull((Object)this.c.getCodeType())) {
                this.c.setCodeType(CaptchaCodeEnum.arithmetic);
            }
        }
        return this.a(this.c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Captcha a(CaptchaInfo captchaInfo) {
        ArithmeticCaptcha arithmeticCaptcha;
        LoginProperties loginProperties = this;
        synchronized (loginProperties) {
            switch (captchaInfo.getCodeType()) {
                case arithmetic: {
                    arithmeticCaptcha = new ArithmeticCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    arithmeticCaptcha.setLen(captchaInfo.getLength());
                    break;
                }
                case chinese: {
                    arithmeticCaptcha = new ChineseCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    arithmeticCaptcha.setLen(captchaInfo.getLength());
                    break;
                }
                case chinese_gif: {
                    arithmeticCaptcha = new ChineseGifCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    arithmeticCaptcha.setLen(captchaInfo.getLength());
                    break;
                }
                case gif: {
                    arithmeticCaptcha = new GifCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    arithmeticCaptcha.setLen(captchaInfo.getLength());
                    break;
                }
                case spec: {
                    arithmeticCaptcha = new SpecCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    arithmeticCaptcha.setLen(captchaInfo.getLength());
                    break;
                }
                default: {
                    throw new BadConfigurationException("\u9a8c\u8bc1\u7801\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff01\uff01\uff01\u6b63\u786e\u914d\u7f6e\u67e5\u770b com.elitesland.yst.common.property.CaptchaCodeEnum ");
                }
            }
        }
        return arithmeticCaptcha;
    }

    public Boolean getIsSingleLogin() {
        return this.a;
    }

    public Boolean getIsCaptchaNeeded() {
        return this.b;
    }

    public CaptchaInfo getCaptchaInfo() {
        return this.c;
    }

    public void setIsSingleLogin(Boolean bl) {
        this.a = bl;
    }

    public void setIsCaptchaNeeded(Boolean bl) {
        this.b = bl;
    }

    public void setCaptchaInfo(CaptchaInfo captchaInfo) {
        this.c = captchaInfo;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LoginProperties)) {
            return false;
        }
        LoginProperties loginProperties = (LoginProperties)object;
        if (!loginProperties.canEqual(this)) {
            return false;
        }
        Boolean bl = this.getIsSingleLogin();
        Boolean bl2 = loginProperties.getIsSingleLogin();
        if (bl == null ? bl2 != null : !((Object)bl).equals(bl2)) {
            return false;
        }
        Boolean bl3 = this.getIsCaptchaNeeded();
        Boolean bl4 = loginProperties.getIsCaptchaNeeded();
        if (bl3 == null ? bl4 != null : !((Object)bl3).equals(bl4)) {
            return false;
        }
        CaptchaInfo captchaInfo = this.getCaptchaInfo();
        CaptchaInfo captchaInfo2 = loginProperties.getCaptchaInfo();
        return !(captchaInfo == null ? captchaInfo2 != null : !((Object)captchaInfo).equals(captchaInfo2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof LoginProperties;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        Boolean bl = this.getIsSingleLogin();
        n2 = n2 * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
        Boolean bl2 = this.getIsCaptchaNeeded();
        n2 = n2 * 59 + (bl2 == null ? 43 : ((Object)bl2).hashCode());
        CaptchaInfo captchaInfo = this.getCaptchaInfo();
        n2 = n2 * 59 + (captchaInfo == null ? 43 : ((Object)captchaInfo).hashCode());
        return n2;
    }

    public String toString() {
        return "LoginProperties(isSingleLogin=" + this.getIsSingleLogin() + ", isCaptchaNeeded=" + this.getIsCaptchaNeeded() + ", captchaInfo=" + this.getCaptchaInfo() + ")";
    }
}

