/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.util;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.UserAgent;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElStringUtils
extends StringUtils {
    private static final Logger log = LoggerFactory.getLogger(ElStringUtils.class);
    private static boolean ipLocal = false;
    private static File file = null;
    private static final char SEPARATOR = '_';
    private static final String UNKNOWN = "unknown";

    public static String toCamelCase(String string) {
        if (string == null) {
            return null;
        }
        string = string.toLowerCase();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append(Character.toUpperCase(c));
                bl = false;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String toCapitalizeCamelCase(String string) {
        if (string == null) {
            return null;
        }
        string = ElStringUtils.toCamelCase(string);
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    static String toUnderScoreCase(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl2 = true;
            if (i < string.length() - 1) {
                bl2 = Character.isUpperCase(string.charAt(i + 1));
            }
            if (i > 0 && Character.isUpperCase(c)) {
                if (!bl || !bl2) {
                    stringBuilder.append('_');
                }
                bl = true;
            } else {
                bl = false;
            }
            stringBuilder.append(Character.toLowerCase(c));
        }
        return stringBuilder.toString();
    }

    public static String getIp(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("x-forwarded-for");
        if (string == null || string.length() == 0 || UNKNOWN.equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("Proxy-Client-IP");
        }
        if (string == null || string.length() == 0 || UNKNOWN.equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("WL-Proxy-Client-IP");
        }
        if (string == null || string.length() == 0 || UNKNOWN.equalsIgnoreCase(string)) {
            string = httpServletRequest.getRemoteAddr();
        }
        String string2 = ",";
        String string3 = "127.0.0.1";
        if (string.contains(string2)) {
            string = string.split(",")[0];
        }
        if (string3.equals(string)) {
            try {
                string = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                log.error(unknownHostException.getMessage(), (Throwable)unknownHostException);
            }
        }
        return string;
    }

    public static String getCityInfo(String string) {
        if (ipLocal) {
            return ElStringUtils.getLocalCityInfo(string);
        }
        return string;
    }

    public static String getHttpCityInfo(String string) {
        String string2 = String.format("http://whois.pconline.com.cn/ipJson.jsp?ip=%s&json=true", string);
        JSONObject jSONObject = JSONUtil.parseObj((String)HttpUtil.get((String)string2));
        return (String)jSONObject.get((Object)"addr", String.class);
    }

    public static String getLocalCityInfo(String string) {
        return "\u5f85\u5b9e\u73b0";
    }

    public static String getBrowser(HttpServletRequest httpServletRequest) {
        UserAgent userAgent = UserAgent.parseUserAgentString((String)httpServletRequest.getHeader("User-Agent"));
        Browser browser = userAgent.getBrowser();
        return browser.getName();
    }

    public static String getWeekDay() {
        String[] stringArray = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int n = calendar.get(7) - 1;
        if (n < 0) {
            n = 0;
        }
        return stringArray[n];
    }

    public static String getLocalIp() {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return UNKNOWN;
        }
        byte[] byArray = inetAddress.getAddress();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(".");
            }
            stringBuilder.append(byArray[i] & 0xFF);
        }
        return stringBuilder.toString();
    }
}

