/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.util;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RsaUtils {
    private static final String SRC = "123456";

    public static void main(String[] stringArray) throws Exception {
        System.out.println("\n");
        RsaKeyPair rsaKeyPair = RsaUtils.generateKeyPair();
        System.out.println("\u516c\u94a5\uff1a" + rsaKeyPair.getPublicKey());
        System.out.println("\u79c1\u94a5\uff1a" + rsaKeyPair.getPrivateKey());
        System.out.println("\n");
        RsaUtils.test1(rsaKeyPair);
        System.out.println("\n");
        RsaUtils.test2(rsaKeyPair);
        System.out.println("\n");
    }

    private static void test1(RsaKeyPair rsaKeyPair) throws Exception {
        System.out.println("***************** \u516c\u94a5\u52a0\u5bc6\u79c1\u94a5\u89e3\u5bc6\u5f00\u59cb *****************");
        String string = RsaUtils.encryptByPublicKey(rsaKeyPair.getPublicKey(), SRC);
        String string2 = RsaUtils.decryptByPrivateKey(rsaKeyPair.getPrivateKey(), string);
        System.out.println("\u52a0\u5bc6\u524d\uff1a123456");
        System.out.println("\u52a0\u5bc6\u540e\uff1a" + string);
        System.out.println("\u89e3\u5bc6\u540e\uff1a" + string2);
        if (SRC.equals(string2)) {
            System.out.println("\u89e3\u5bc6\u5b57\u7b26\u4e32\u548c\u539f\u59cb\u5b57\u7b26\u4e32\u4e00\u81f4\uff0c\u89e3\u5bc6\u6210\u529f");
        } else {
            System.out.println("\u89e3\u5bc6\u5b57\u7b26\u4e32\u548c\u539f\u59cb\u5b57\u7b26\u4e32\u4e0d\u4e00\u81f4\uff0c\u89e3\u5bc6\u5931\u8d25");
        }
        System.out.println("***************** \u516c\u94a5\u52a0\u5bc6\u79c1\u94a5\u89e3\u5bc6\u7ed3\u675f *****************");
    }

    private static void test2(RsaKeyPair rsaKeyPair) throws Exception {
        System.out.println("***************** \u79c1\u94a5\u52a0\u5bc6\u516c\u94a5\u89e3\u5bc6\u5f00\u59cb *****************");
        String string = RsaUtils.encryptByPrivateKey(rsaKeyPair.getPrivateKey(), SRC);
        String string2 = RsaUtils.decryptByPublicKey(rsaKeyPair.getPublicKey(), string);
        System.out.println("\u52a0\u5bc6\u524d\uff1a123456");
        System.out.println("\u52a0\u5bc6\u540e\uff1a" + string);
        System.out.println("\u89e3\u5bc6\u540e\uff1a" + string2);
        if (SRC.equals(string2)) {
            System.out.println("\u89e3\u5bc6\u5b57\u7b26\u4e32\u548c\u539f\u59cb\u5b57\u7b26\u4e32\u4e00\u81f4\uff0c\u89e3\u5bc6\u6210\u529f");
        } else {
            System.out.println("\u89e3\u5bc6\u5b57\u7b26\u4e32\u548c\u539f\u59cb\u5b57\u7b26\u4e32\u4e0d\u4e00\u81f4\uff0c\u89e3\u5bc6\u5931\u8d25");
        }
        System.out.println("***************** \u79c1\u94a5\u52a0\u5bc6\u516c\u94a5\u89e3\u5bc6\u7ed3\u675f *****************");
    }

    public static String decryptByPublicKey(String string, String string2) throws Exception {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)string));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, publicKey);
        byte[] byArray = cipher.doFinal(Base64.decodeBase64((String)string2));
        return new String(byArray);
    }

    public static String encryptByPrivateKey(String string, String string2) throws Exception {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)string));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, privateKey);
        byte[] byArray = cipher.doFinal(string2.getBytes());
        return Base64.encodeBase64String((byte[])byArray);
    }

    public static String decryptByPrivateKey(String string, String string2) throws Exception {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)string));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        byte[] byArray = cipher.doFinal(Base64.decodeBase64((String)string2));
        return new String(byArray);
    }

    public static String encryptByPublicKey(String string, String string2) throws Exception {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)string));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        byte[] byArray = cipher.doFinal(string2.getBytes());
        return Base64.encodeBase64String((byte[])byArray);
    }

    public static RsaKeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(1024);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPublicKey rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        String string = Base64.encodeBase64String((byte[])rSAPublicKey.getEncoded());
        String string2 = Base64.encodeBase64String((byte[])rSAPrivateKey.getEncoded());
        return new RsaKeyPair(string, string2);
    }

    public static class RsaKeyPair {
        private final String a;
        private final String b;

        public RsaKeyPair(String string, String string2) {
            this.a = string;
            this.b = string2;
        }

        public String getPublicKey() {
            return this.a;
        }

        public String getPrivateKey() {
            return this.b;
        }
    }
}

