/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.base;

import cn.hutool.core.util.StrUtil;
import com.elitesland.yst.common.base.ApiCode;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

public class ApiResult<T>
implements Serializable {
    private static final long serialVersionUID = 7722914707623525357L;
    private int code;
    private String msg;
    private String errorMsg;
    private boolean success;
    private T data;
    private LocalDateTime time;

    public ApiResult() {
    }

    public static <T> ApiResult<T> result(boolean flag) {
        if (flag) {
            return ApiResult.ok();
        }
        return ApiResult.fail();
    }

    public static <T> ApiResult<T> result(ApiCode apiCode) {
        return ApiResult.result(apiCode, null);
    }

    public static <T> ApiResult<T> result(ApiCode apiCode, T data) {
        return ApiResult.result(apiCode, null, data);
    }

    public static <T> ApiResult<T> result(ApiCode apiCode, String msg, T data) {
        boolean success = apiCode == ApiCode.SUCCESS;
        return ApiResult.builder().code(apiCode.getCode()).msg(StrUtil.isBlank((CharSequence)msg) ? apiCode.getMsgFriendly() : msg).errorMsg(apiCode.getMsg()).data(data).success(success).time(LocalDateTime.now()).build();
    }

    public static <T> ApiResult<T> ok() {
        return ApiResult.ok(null);
    }

    public static <T> ApiResult<T> ok(T data) {
        return ApiResult.result(ApiCode.SUCCESS, data);
    }

    public static <T> ApiResult<T> ok(T data, String msg) {
        return ApiResult.result(ApiCode.SUCCESS, msg, data);
    }

    public static <T> ApiResult<Map<String, T>> okMap(String key, T value) {
        HashMap<String, T> map = new HashMap<String, T>(1);
        map.put(key, value);
        return ApiResult.ok(map);
    }

    public static Map<String, Object> toMap(ApiResult<?> result) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", result.code);
        map.put("msg", result.msg);
        map.put("data", result.data);
        map.put("success", result.success);
        map.put("time", result.time);
        return map;
    }

    public static <T> ApiResult<T> fail(ApiCode apiCode) {
        return ApiResult.result(apiCode, null);
    }

    public static <T> ApiResult<T> fail(String msg) {
        return ApiResult.result(ApiCode.FAIL, msg, null);
    }

    public static ApiResult<Object> fail(ApiCode apiCode, String msg) {
        if (ApiCode.SUCCESS == apiCode) {
            throw new IllegalArgumentException("\u5931\u8d25\u7ed3\u679c\u72b6\u6001\u7801\u4e0d\u80fd\u4e3a" + ApiCode.SUCCESS.getCode());
        }
        return ApiResult.result(apiCode, msg, null);
    }

    public static <T> ApiResult<T> fail(ApiCode apiCode, T data) {
        if (ApiCode.SUCCESS == apiCode) {
            throw new IllegalArgumentException("\u5931\u8d25\u7ed3\u679c\u72b6\u6001\u7801\u4e0d\u80fd\u4e3a" + ApiCode.SUCCESS.getCode());
        }
        return ApiResult.result(apiCode, data);
    }

    public static <T> ApiResult<T> fail(ApiCode apiCode, T data, String msg) {
        if (ApiCode.SUCCESS == apiCode) {
            throw new IllegalArgumentException("\u5931\u8d25\u7ed3\u679c\u72b6\u6001\u7801\u4e0d\u80fd\u4e3a" + ApiCode.SUCCESS.getCode());
        }
        return ApiResult.result(apiCode, msg, data);
    }

    public static <T> ApiResult<Map<String, T>> fail(String key, T value) {
        HashMap<String, T> map = new HashMap<String, T>(1);
        map.put(key, value);
        return ApiResult.result(ApiCode.FAIL, map);
    }

    public static <T> ApiResult<T> fail() {
        return ApiResult.fail(ApiCode.FAIL);
    }

    private static <T> LocalDateTime $default$time() {
        return LocalDateTime.now();
    }

    public static <T> ApiResultBuilder<T> builder() {
        return new ApiResultBuilder();
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public T getData() {
        return this.data;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public ApiResult<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public ApiResult<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public ApiResult<T> setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public ApiResult<T> setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public ApiResult<T> setData(T data) {
        this.data = data;
        return this;
    }

    public ApiResult<T> setTime(LocalDateTime time) {
        this.time = time;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiResult)) {
            return false;
        }
        ApiResult other = (ApiResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        LocalDateTime this$time = this.getTime();
        LocalDateTime other$time = other.getTime();
        return !(this$time == null ? other$time != null : !((Object)this$time).equals(other$time));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        LocalDateTime $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        return result;
    }

    public String toString() {
        return "ApiResult(code=" + this.getCode() + ", msg=" + this.getMsg() + ", errorMsg=" + this.getErrorMsg() + ", success=" + this.isSuccess() + ", data=" + this.getData() + ", time=" + this.getTime() + ")";
    }

    public ApiResult(int code, String msg, String errorMsg, boolean success, T data, LocalDateTime time) {
        this.code = code;
        this.msg = msg;
        this.errorMsg = errorMsg;
        this.success = success;
        this.data = data;
        this.time = time;
    }

    public static class ApiResultBuilder<T> {
        private int code;
        private String msg;
        private String errorMsg;
        private boolean success;
        private T data;
        private boolean time$set;
        private LocalDateTime time$value;

        ApiResultBuilder() {
        }

        public ApiResultBuilder<T> code(int code) {
            this.code = code;
            return this;
        }

        public ApiResultBuilder<T> msg(String msg) {
            this.msg = msg;
            return this;
        }

        public ApiResultBuilder<T> errorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this;
        }

        public ApiResultBuilder<T> success(boolean success) {
            this.success = success;
            return this;
        }

        public ApiResultBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public ApiResultBuilder<T> time(LocalDateTime time) {
            this.time$value = time;
            this.time$set = true;
            return this;
        }

        public ApiResult<T> build() {
            LocalDateTime time$value = this.time$value;
            if (!this.time$set) {
                time$value = ApiResult.$default$time();
            }
            return new ApiResult<T>(this.code, this.msg, this.errorMsg, this.success, this.data, time$value);
        }

        public String toString() {
            return "ApiResult.ApiResultBuilder(code=" + this.code + ", msg=" + this.msg + ", errorMsg=" + this.errorMsg + ", success=" + this.success + ", data=" + this.data + ", time$value=" + this.time$value + ")";
        }
    }
}

