/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.base.param;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.param.QueryParam;
import com.elitesland.yst.common.exception.BusinessException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.PathBuilderValidator;
import com.querydsl.jpa.impl.JPAQuery;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

@ApiModel(value="\u53ef\u6392\u5e8f\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61")
public abstract class AbstractOrderQueryParam
extends QueryParam {
    private static final long serialVersionUID = 57714391204790143L;
    @ApiModelProperty(value="\u6392\u5e8f")
    private List<OrderItem> orders;

    public List<OrderItem> getOrders() {
        return this.orders;
    }

    public void setOrders(List<OrderItem> orders) {
        this.orders = orders;
    }

    public void defaultOrder(OrderItem orderItem) {
        this.defaultOrders(Collections.singletonList(orderItem));
    }

    public void defaultOrders(List<OrderItem> orderItems) {
        if (CollectionUtils.isEmpty(orderItems)) {
            return;
        }
        this.orders = orderItems;
    }

    @JsonIgnore
    public PageRequest getPageRequest() {
        ArrayList orderBys = CollectionUtils.isEmpty(this.orders) ? new ArrayList() : this.orders.stream().map(o -> new Sort.Order(o.isAsc() ? Sort.Direction.ASC : Sort.Direction.DESC, o.getColumn())).collect(Collectors.toList());
        return PageRequest.of((int)this.getCurrent(), (int)this.getSize(), (Sort)Sort.by(orderBys));
    }

    @JsonIgnore
    public void fillOrders(JPAQuery<?> query, EntityPathBase entityPathBase) {
        PageRequest pageRequest = this.getPageRequest();
        PathBuilder orderbyExpr = new PathBuilder(entityPathBase.getClass(), entityPathBase.getMetadata(), PathBuilderValidator.FIELDS);
        pageRequest.getSort().forEach(s -> query.orderBy(new OrderSpecifier(s.isAscending() ? Order.ASC : Order.DESC, (Expression)orderbyExpr.get(s.getProperty()))));
    }

    @JsonIgnore
    public void fillOrders(JPAQuery<?> query) {
        PageRequest pageRequest = this.getPageRequest();
        pageRequest.getSort().forEach(s -> {
            String[] sects = s.getProperty().split("\\.");
            if (sects.length <= 1) {
                throw new BusinessException(ApiCode.PARAMETER_PARSE_EXCEPTION, "\u6392\u5e8f\u5b57\u6bb5\u9700\u8981\u6307\u5b9a\u6240\u5c5ehql\u7684\u5b9e\u4f53\u5bf9\u8c61\uff0c\u5bf9\u8c61\u540d\u79f0.\u5b57\u6bb5\u540d\u79f0");
            }
            PathBuilder orderbyExpr = new PathBuilder(Object.class, sects[0]);
            query.orderBy(new OrderSpecifier(s.isAscending() ? Order.ASC : Order.DESC, (Expression)orderbyExpr.get(sects[1])));
        });
    }

    @JsonIgnore
    public void setPaging(JPAQuery<?> query) {
        query.offset((long)(this.getCurrent() * this.getSize()));
        query.limit((long)this.getSize().intValue());
    }

    @Override
    public String toString() {
        return "AbstractOrderQueryParam(orders=" + this.getOrders() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractOrderQueryParam)) {
            return false;
        }
        AbstractOrderQueryParam other = (AbstractOrderQueryParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<OrderItem> this$orders = this.getOrders();
        List<OrderItem> other$orders = other.getOrders();
        return !(this$orders == null ? other$orders != null : !((Object)this$orders).equals(other$orders));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractOrderQueryParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<OrderItem> $orders = this.getOrders();
        result = result * 59 + ($orders == null ? 43 : ((Object)$orders).hashCode());
        return result;
    }
}

