package com.elitesland.yst.common.base;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <pre>
 *     JPA数据实体类的基础类，用于唯一ID生成策略绑定
 *     审计字段、版本和逻辑删除标记，
 *     未来扩展租户ID信息
 * </pre>
 *
 * @author Moz
 * @date 3/17/2020
 */
@Data
public class BaseViewModel implements Serializable {

    private static final long serialVersionUID = 8856368218499373995L;
    @ApiModelProperty("记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "租户ID")
    Long tenantId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty("记录创建者ID")
    private Long createUserId = 0L;

    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime = LocalDateTime.now();

    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId = 0L;

    @ApiModelProperty("记录最后更新者")
    String updater;

    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime = LocalDateTime.now();

    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag = 0;

    @ApiModelProperty(value = "锁版本")
    private Integer auditDataVersion;
}
