package com.elitesland.yst.common.base;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * @author Michael Li
 * @date 2018-11-08
 */
@ApiModel("分页")
@Data
@Accessors(chain = true)
@Builder
public class PagingVO<T> implements Serializable {

    private static final long serialVersionUID = -1683800405530086022L;

    @ApiModelProperty("总行数")
    @JsonProperty("total")
    @Builder.Default
    private Long total = 0L;

    @ApiModelProperty("数据列表")
    @JsonProperty("records")
    @Builder.Default
    private List<T> records = Collections.emptyList();

    public PagingVO() {
    }

    public PagingVO(long total, List<T> records) {
        this.total = total;
        this.records = records;
    }

    @Override
    public String toString() {
        return "Paging{" +
                "total=" + total +
                ", records=" + records +
                '}';
    }
}
