package com.elitesland.yst.common.config;

import com.elitesland.yst.common.exception.filter.ExceptionFilter;
import com.elitesland.yst.common.property.EliteslandServiceProperties;
import com.elitesland.yst.common.property.LoginProperties;
import com.elitesland.yst.common.property.OAuth2Properties;
import com.elitesland.yst.common.property.SpecialAccountProperties;
import com.elitesland.yst.common.util.SpringContextHolder;
import lombok.val;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author mir
 */
@Configuration
public class EliteslandConfig {

    @Bean
    @ConfigurationProperties(prefix = "elitesland.oauth2")
    public OAuth2Properties oauth2Properties() {
        return new OAuth2Properties();
    }

    @Bean
    @ConfigurationProperties(prefix = "elitesland.service")
    public EliteslandServiceProperties eliteslandServiceProperties() {
        return new EliteslandServiceProperties();
    }

    @Bean
    @ConfigurationProperties(prefix = "elitesland.login")
    public LoginProperties loginProperties() {
        return new LoginProperties();
    }

    @Bean
    @ConfigurationProperties(prefix = "elitesland.special.account")
    public SpecialAccountProperties specialAccountProperties() {
        return new SpecialAccountProperties();
    }

    @Bean
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder();
    }

    @Bean
    public ExceptionFilter exceptionFilter() {
        return new ExceptionFilter();
    }

    @Bean
    public FilterRegistrationBean registrationBean() {
        val bean = new FilterRegistrationBean<>();
        bean.setFilter(exceptionFilter());
        bean.addUrlPatterns("/*");
        bean.setOrder(1);

        return bean;
    }
}
