package com.elitesland.yst.common.util;

import com.elitesland.yst.common.micro.Snowflake;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;

import java.io.Serializable;

/**
 * 适用于JPA的基于Snowflake算法的ID生成器
 *
 * @author Moz
 * @date 3/17/2020
 */
public class IdGenerator implements IdentifierGenerator {

    private final Snowflake snowflake = new Snowflake(1);

    @Override
    public Serializable generate(SharedSessionContractImplementor sharedSessionContractImplementor, Object o) throws HibernateException {
        return snowflake.nextId();
    }

    public Snowflake getSnowflake() {
        return this.snowflake;
    }
}
