/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.config.json;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LocalDateTimeSerializerConfig {
    @Value(value="${spring.jackson.date-format:yyyy-MM-dd HH:mm:ss}")
    private String pattern;
    private LocalDateTimeSerializer localDateTimeSerializer;
    private LocalDateTimeDeserializer localDateTimeDeserializer;

    @Autowired
    public void setLocalDateTimeSerializer(LocalDateTimeSerializer localDateTimeSerializer) {
        this.localDateTimeSerializer = localDateTimeSerializer;
    }

    @Autowired
    public void setLocalDateTimeDeserializer(LocalDateTimeDeserializer localDateTimeDeserializer) {
        this.localDateTimeDeserializer = localDateTimeDeserializer;
    }

    @Bean
    public LocalDateTimeSerializer localDateTimeSerializer() {
        return new LocalDateTimeSerializer(DateTimeFormatter.ofPattern(this.pattern));
    }

    @Bean
    public LocalDateTimeDeserializer localDateTimeDeserializer() {
        return new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern(this.pattern));
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer jackson2ObjectMapperBuilderCustomizer() {
        return jacksonObjectMapperBuilder -> {
            jacksonObjectMapperBuilder.serializerByType(LocalDateTime.class, (JsonSerializer)this.localDateTimeSerializer);
            jacksonObjectMapperBuilder.deserializerByType(LocalDateTime.class, (JsonDeserializer)this.localDateTimeDeserializer);
        };
    }
}

