package com.elitesland.yst.common.base;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 当前用户信息，暂时先提供三个属性，后面在加
 * <p>
 *
 * @author Roman.Zhang
 * @date 2021/4/2
 */
@ApiModel("用户信息")
@Data
@Accessors(chain = true)
@Builder
public class CurrentUserVO implements Serializable {
    private static final long serialVersionUID = 969863956221404847L;

    /**
     * 用户ID
     */
    @ApiModelProperty("用户id")
    private Long id;

    /**
     * 用户名称
     */
    @ApiModelProperty("用户名称")
    private String userName;

    /**
     * 用户角色
     */
    @ApiModelProperty("用户角色")
    private List userRoles;
}
