package com.elitesland.yst.common.config.dynamic.datasource;

import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;

/**
 * <p>
 *  注册动态数据源
 *  初始化数据源和提供了执行动态切换数据源的工具类
 * <p>
 *  TODO 注释先不删除，待功能较为完善后在删除
 * @author Roman.Zhang
 * @date 2022/2/17
 */
@Slf4j
@Configuration
public class DynamicDataSourceRegister {
    @Bean
    @Primary
    @DependsOn({"springUtils", "shardingDataSource"})
    public DynamicDataSource dataSource() {
        DynamicDataSource dynamicDataSource = new DynamicDataSource();
        dynamicDataSource.setTargetDataSources(DynamicDataSource.dataSourcesMap);
        return dynamicDataSource;
    }
}
