package com.elitesland.yst.common.exception.filter;

import com.elitesland.yst.common.constant.SysConstants;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.web.filter.GenericFilterBean;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;
import java.util.Objects;

@Slf4j
public class ExceptionFilter extends GenericFilterBean {

    @Override
    protected void initFilterBean() throws ServletException {
        super.initFilterBean();
        log.info("ex filter initiating ...");
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        val isRethrow = !Objects.isNull(request.getAttribute(SysConstants.GLOBALE_EXCEPTION_ATTR));

        if (isRethrow) {
            chain.doFilter(request, response);
            return;
        }
        try {
            chain.doFilter(request, response);
        } catch (Exception e) {
            request.setAttribute(SysConstants.GLOBALE_EXCEPTION_ATTR, e);
            request.getRequestDispatcher("/common/exceptions").forward(request, response);
        }
    }
}
