package com.elitesland.yst.common.util;

import org.hibernate.validator.HibernateValidator;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import java.util.Set;

/**
 * 校验工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2021/5/18
 */
public class ValidatorUtil {

    private ValidatorUtil() {
    }

    private static final Validator VALIDATOR_FAST = Validation.byProvider(HibernateValidator.class).configure().failFast(true).buildValidatorFactory().getValidator();
    private static final Validator VALIDATOR_ALL = Validation.byProvider(HibernateValidator.class).configure().failFast(false).buildValidatorFactory().getValidator();

    /**
     * 快速校验
     * <p>
     * 检查到第一个不合法的字段后就停止，后续字段不再校验
     *
     * @param pojo 待检查对象
     * @param <T>  对象类型
     * @return 检查结果
     */
    public static <T> Set<ConstraintViolation<T>> validateFast(T pojo) {
        return VALIDATOR_FAST.validate(pojo);
    }

    /**
     * 全部校验
     * <p>
     * 校验所有字段
     *
     * @param pojo 待检查对象
     * @param <T>  对象类型
     * @return 检查结果
     */
    public static <T> Set<ConstraintViolation<T>> validateAll(T pojo) {
        return VALIDATOR_ALL.validate(pojo);
    }
}
