package com.elitesland.yst.common.common;

import java.io.Serializable;

/**
 * 自定义可序列化的Optional.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/27
 */
public class CloudtOptional<T extends Serializable> implements Serializable {
    private static final long serialVersionUID = 7910368329628507484L;

    private T value;

    public CloudtOptional(T value) {
        this.value = value;
    }

    public CloudtOptional() {
    }

    public static <T extends Serializable> CloudtOptional<T> of(T value) {
        return new CloudtOptional<>(value);
    }

    public boolean isPresent() {
        return value != null;
    }

    public boolean isEmpty() {
        return value == null;
    }

    public T get() {
        return value;
    }
}
