package com.elitesland.yst.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ResultHolder {
    private static Map<String, Map<String, String>> map = new HashMap<>();

    public static void setResult(String actionClass, String xid, String v) {
        Map<String, String> resultsMap = map.get(actionClass);
        if (resultsMap == null) {
            synchronized (ResultHolder.class) {
                if (resultsMap == null) {
                    resultsMap = new ConcurrentHashMap<>();
                    map.put(actionClass, resultsMap);
                }
            }
        }
        resultsMap.put(xid, v);
    }

    public static String getResult(String actionClass, String xid) {
        Map<String, String> resultMap = map.get(actionClass);
        if (resultMap != null) {
            return resultMap.get(xid);
        }
        return null;
    }

    public static void removeResult(String actionClass, String xid) {
        Map<String, String> resultMap = map.get(actionClass);
        if (resultMap != null) {
            resultMap.remove(xid);
        }
    }
}
