/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.config;

import com.elitesland.yst.common.config.CacheKeyGenerator;
import com.elitesland.yst.common.config.CloudtRedisProperties;
import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;
import org.redisson.api.RedissonClient;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.cache.CacheConfigSupport;
import org.redisson.spring.cache.RedissonSpringCacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
public class CacheRedisConfig
extends CacheConfigSupport {
    private final CloudtRedisProperties cloudtRedisProperties;
    private final CacheKeyGenerator cacheKeyGenerator;

    public CacheRedisConfig(CloudtRedisProperties cloudtRedisProperties, CacheKeyGenerator cacheKeyGenerator) {
        this.cloudtRedisProperties = cloudtRedisProperties;
        this.cacheKeyGenerator = cacheKeyGenerator;
    }

    @Bean
    @Primary
    @Autowired
    public CacheManager redisCacheManager(RedisConnectionFactory redisConnectionFactory) {
        return new RedisCacheManager(RedisCacheWriter.lockingRedisCacheWriter((RedisConnectionFactory)redisConnectionFactory), RedisCacheConfiguration.defaultCacheConfig().disableCachingNullValues().computePrefixWith(this.cacheKeyGenerator::computeKey));
    }

    @Bean
    @Autowired
    public CacheManager redissonManager(RedissonClient redissonClient) {
        HashedMap configHashedMap = new HashedMap();
        configHashedMap.put((Object)(this.cloudtRedisProperties.getPrefix() + ":longCache"), (Object)new CacheConfig(180000L, 120000L));
        configHashedMap.put((Object)(this.cloudtRedisProperties.getPrefix() + ":shortCache"), (Object)new CacheConfig(60000L, 30000L));
        return new RedissonSpringCacheManager(redissonClient, (Map)configHashedMap);
    }
}

