/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.util;

import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RuntimeUtil;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.common.micro.Snowflake;
import com.elitesland.yst.common.property.IdProperties;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class IdGenerator
implements IdentifierGenerator {
    private static final Logger log = LoggerFactory.getLogger(IdGenerator.class);
    private static volatile Snowflake snowflake = null;
    private static IdProperties idProperties;
    private static RedisTemplate redisTemplate;
    private static final Object LOCK;
    private static String CACHE_KEY;
    private static String dataCenterName;
    private static Long dataCenterId;
    private static Long workerId;

    public Serializable generate(SharedSessionContractImplementor sharedSessionContractImplementor, Object o) throws HibernateException {
        return IdGenerator.getSnowflake().nextId();
    }

    public static void init(IdProperties idProperties, RedisTemplate redisTemplate, String defaultDataCenterName) {
        IdGenerator.idProperties = Objects.requireNonNull(idProperties);
        IdGenerator.redisTemplate = Objects.requireNonNull(redisTemplate);
        dataCenterName = Objects.requireNonNull(defaultDataCenterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Snowflake getSnowflake() {
        if (snowflake == null) {
            Object object = LOCK;
            synchronized (object) {
                if (snowflake == null) {
                    snowflake = IdGenerator.generateSnowflake();
                }
            }
        }
        return snowflake;
    }

    public static void destroy() {
        if (snowflake == null || redisTemplate == null) {
            return;
        }
        if (!Boolean.TRUE.equals(idProperties.getSnowflake().getGenAuto())) {
            return;
        }
        log.info("\u9500\u6bc1Snowflake\u5b9e\u4f8b");
        try {
            SetOperations opsSet = redisTemplate.opsForSet();
            redisTemplate.delete((Object)IdGenerator.cacheKeyWorkerId(workerId));
            opsSet.remove((Object)IdGenerator.cacheKeyDataCenterWorker(), new Object[]{workerId.toString()});
            Long remain = opsSet.size((Object)IdGenerator.cacheKeyDataCenterWorker());
            if (remain == null || remain == 0L) {
                log.info("{}\u4e0b\u7684worker\u5b9e\u4f8b\u5747\u5df2\u4e0d\u5728", (Object)dataCenterName);
                redisTemplate.delete(List.of(IdGenerator.cacheKeyDataCenterID(dataCenterName), IdGenerator.cacheKeyDataCenterID(dataCenterId)));
            }
        }
        catch (Exception e) {
            log.error("\u9500\u6bc1IdGenerator\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public static void refreshAlive() {
        if (snowflake == null || redisTemplate == null) {
            return;
        }
        if (dataCenterId == null || workerId == null) {
            return;
        }
        ValueOperations opsValue = redisTemplate.opsForValue();
        SetOperations opsSet = redisTemplate.opsForSet();
        Duration alive = idProperties.getSnowflake().getAlive();
        opsValue.set((Object)IdGenerator.cacheKeyDataCenterID(dataCenterName), (Object)dataCenterId.toString(), alive);
        opsValue.set((Object)IdGenerator.cacheKeyDataCenterID(dataCenterId), (Object)dataCenterName, alive);
        opsValue.set((Object)IdGenerator.cacheKeyWorkerId(workerId), (Object)IdGenerator.getIp(), alive);
        opsSet.add((Object)IdGenerator.cacheKeyDataCenterWorker(), new Object[]{workerId.toString()});
    }

    private static Snowflake generateSnowflake() {
        Objects.requireNonNull(idProperties, "Snowflake\u5c1a\u672a\u521d\u59cb\u5316");
        IdProperties.Snowflake snowflakeProperties = idProperties.getSnowflake();
        if (!Boolean.TRUE.equals(idProperties.getSnowflake().getGenAuto())) {
            return IdGenerator.generateByManual(snowflakeProperties);
        }
        Objects.requireNonNull(redisTemplate);
        if (StringUtils.hasText((String)snowflakeProperties.getCachePrefix())) {
            CACHE_KEY = snowflakeProperties.getCachePrefix();
        }
        Assert.isTrue((snowflakeProperties.getAlive() != null && snowflakeProperties.getAlive().toSeconds() > 0L ? 1 : 0) != 0, (String)"alive\u8bbe\u7f6e\u6709\u8bef");
        Assert.isTrue((snowflakeProperties.getHeartBeat() != null && snowflakeProperties.getHeartBeat().toSeconds() < snowflakeProperties.getAlive().toSeconds() ? 1 : 0) != 0, (String)"heartBeat\u8bbe\u7f6e\u6709\u8bef");
        IdGenerator.generateDataCenterId();
        IdGenerator.generateWorkerId();
        RuntimeUtil.addShutdownHook(IdGenerator::destroy);
        log.info("ID\u751f\u6210\u5668\u521d\u59cb\u5316\u5b8c\u6210\uff1a{}\u3010{}-{}\u3011", new Object[]{dataCenterName, dataCenterId, workerId});
        return IdGenerator.buildSnowflake();
    }

    private static Snowflake generateByManual(IdProperties.Snowflake snowflakeProperties) {
        dataCenterId = snowflakeProperties.getDataCenterId();
        workerId = snowflakeProperties.getWorkerId();
        Assert.isTrue((dataCenterId != null && dataCenterId > 0L ? 1 : 0) != 0, (String)"dataCenterId\u8bbe\u7f6e\u6709\u8bef");
        Assert.isTrue((workerId != null && workerId > 0L ? 1 : 0) != 0, (String)"dataCenterId\u8bbe\u7f6e\u6709\u8bef");
        return IdGenerator.buildSnowflake();
    }

    private static Snowflake buildSnowflake() {
        return new Snowflake(dataCenterId, workerId, true, 5L, true);
    }

    private static void generateDataCenterId() {
        long temp;
        dataCenterId = IdGenerator.existsDataCenterId(dataCenterName);
        if (dataCenterId != null) {
            return;
        }
        long max = Snowflake.getMaxDataCenterId();
        ValueOperations opsValue = redisTemplate.opsForValue();
        for (temp = 0L; temp < max; ++temp) {
            Boolean result = opsValue.setIfAbsent((Object)IdGenerator.cacheKeyDataCenterID(temp), (Object)dataCenterName, idProperties.getSnowflake().getAlive());
            if (!Boolean.TRUE.equals(result)) continue;
            IdGenerator.checkDataCenterId(temp);
            break;
        }
        if (temp >= max) {
            throw new BusinessException("dataCenterId\u8d85\u8fc7\u9650\u5236" + max);
        }
    }

    private static void checkDataCenterId(Long tempDataCenterId) {
        Boolean result = redisTemplate.opsForValue().setIfAbsent((Object)IdGenerator.cacheKeyDataCenterID(dataCenterName), (Object)tempDataCenterId.toString(), idProperties.getSnowflake().getAlive());
        if (Boolean.TRUE.equals(result)) {
            dataCenterId = tempDataCenterId;
            return;
        }
        dataCenterId = IdGenerator.existsDataCenterId(dataCenterName);
        redisTemplate.delete((Object)IdGenerator.cacheKeyDataCenterID(tempDataCenterId));
    }

    private static void generateWorkerId() {
        long max = Snowflake.getMaxWorkerId();
        ValueOperations opsValue = redisTemplate.opsForValue();
        String ip = IdGenerator.getIp();
        for (long temp = 0L; temp < max; ++temp) {
            Boolean result = opsValue.setIfAbsent((Object)IdGenerator.cacheKeyWorkerId(temp), (Object)ip, idProperties.getSnowflake().getAlive());
            if (!Boolean.TRUE.equals(result)) continue;
            workerId = temp;
            redisTemplate.opsForSet().add((Object)IdGenerator.cacheKeyDataCenterWorker(), new Object[]{workerId.toString()});
            return;
        }
        throw new BusinessException("workerId\u8d85\u8fc7\u9650\u5236" + max);
    }

    private static Long existsDataCenterId(String dataCenterName) {
        Object val = redisTemplate.opsForValue().get((Object)IdGenerator.cacheKeyDataCenterID(dataCenterName));
        if (val == null || val instanceof Long) {
            return (Long)val;
        }
        return Long.parseLong(val.toString());
    }

    private static String cacheKeyDataCenterID(String dataCenterName) {
        return CACHE_KEY + ":" + dataCenterName;
    }

    private static String cacheKeyDataCenterID(Long theDataCenterId) {
        return CACHE_KEY + ":dataCenter_" + theDataCenterId;
    }

    private static String cacheKeyWorkerId(Long theWorkerId) {
        return CACHE_KEY + ":worker_" + dataCenterId + "_" + theWorkerId;
    }

    private static String cacheKeyDataCenterWorker() {
        return CACHE_KEY + ":" + dataCenterId;
    }

    private static String getIp() {
        return (String)ObjectUtil.defaultIfNull((Object)NetUtil.getLocalhost().getHostAddress(), (Object)"127.0.0.1");
    }

    static {
        LOCK = new Object();
        CACHE_KEY = "cloudt_snowflake";
        dataCenterName = "unknown";
    }
}

