/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.base;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.yst.common.common.CloudtContextHolder;
import java.util.Map;
import org.springframework.util.StringUtils;

public enum ApiCode {
    SUCCESS(200, "\u64cd\u4f5c\u6210\u529f"),
    UNAUTHORIZED(401, "\u6682\u672a\u767b\u5f55\u6216token\u5df2\u7ecf\u8fc7\u671f"),
    NOT_PERMISSION(403, "\u6ca1\u6709\u6743\u9650"),
    NOT_FOUND(404, "\u4f60\u8bf7\u6c42\u7684\u8d44\u6e90\u4e0d\u5b58\u5728"),
    FAIL(500, "\u64cd\u4f5c\u5931\u8d25"),
    VALIDATE_FAILED(404, "\u53c2\u6570\u68c0\u9a8c\u5931\u8d25"),
    FORBIDDEN(403, "\u6ca1\u6709\u76f8\u5173\u6743\u9650"),
    AUTHENTICATION_CLIENT_FORBIDDEN(401, "\u5ba2\u6237\u7aef\u9a8c\u8bc1\u5931\u8d25"),
    METHOD_NOT_SUPPORT(401, "\u8bf7\u6c42\u65b9\u5f0f\u4e0d\u652f\u6301"),
    LOGIN_EXCEPTION(4000, "\u767b\u5f55\u5931\u8d25"),
    SYSTEM_EXCEPTION(9900, "\u7cfb\u7edf\u5f02\u5e38"),
    PARAMETER_EXCEPTION(9901, "\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5f02\u5e38"),
    PARAMETER_PARSE_EXCEPTION(9902, "\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u5f02\u5e38"),
    HTTP_MEDIA_TYPE_EXCEPTION(9903, "HTTP Media \u7c7b\u578b\u5f02\u5e38"),
    BUSINESS_EXCEPTION(9904, "\u4e1a\u52a1\u5904\u7406\u5f02\u5e38"),
    DAO_EXCEPTION(9905, "\u6570\u636e\u5e93\u5904\u7406\u5f02\u5e38"),
    VERIFICATION_CODE_EXCEPTION(9906, "\u9a8c\u8bc1\u7801\u6821\u9a8c\u5f02\u5e38"),
    AUTHENTICATION_EXCEPTION(9907, "\u767b\u5f55\u6388\u6743\u5f02\u5e38"),
    UNAUTHENTICATED_EXCEPTION(9908, "\u8eab\u4efd\u8ba4\u8bc1\u4e0d\u6b63\u786e"),
    UNAUTHORIZED_EXCEPTION(9909, "\u6ca1\u6709\u8bbf\u95ee\u6743\u9650"),
    UNAUTHORIZED_ANONYMOUS(9910, "\u533f\u540d\u7528\u6237\uff0c\u672a\u6388\u6743\u8bbf\u95ee"),
    NO_USER_FOUND_EXCEPTION(9911, "\u7528\u6237\u4fe1\u606f\u672a\u627e\u5230"),
    USER_DISABLED_EXCEPTION(9912, "\u7528\u6237\u8d26\u53f7\u5df2\u88ab\u7981\u7528"),
    TOKEN_ACCESS_FORBIDDEN(9913, "token\u5df2\u88ab\u7981\u6b62\u8bbf\u95ee"),
    CLOUD_SERVICE_EXCEPTION(9914, "\u670d\u52a1\u8c03\u7528\u5931\u8d25"),
    CLOUD_SERVICE_UNAVAILABLE(9915, "\u670d\u52a1\u4e0d\u53ef\u7528"),
    THREAD_OVERFLOW(9916, "\u7ebf\u7a0b\u6c60\u6ea2\u51fa"),
    SERVER_RESPONSE_TIMEOUT(9917, "\u670d\u52a1\u5668\u54cd\u5e94\u8d85\u65f6"),
    ROCKETMQ_MESSAGE_EMPTY(9918, "MQ\u6d88\u606f\u4e3b\u9898\u6d88\u606f\u4e3a\u7a7a");

    private final int code;
    private final String msg;

    private ApiCode(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static ApiCode getApiCode(int code) {
        ApiCode[] ecs;
        for (ApiCode ec : ecs = ApiCode.values()) {
            if (ec.getCode() != code) continue;
            return ec;
        }
        return SUCCESS;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getMsgFriendly(String errorNo) {
        switch (this) {
            case SUCCESS: {
                return SUCCESS.getMsg();
            }
            case UNAUTHORIZED: {
                return "\u767b\u5f55\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
            }
            case NOT_PERMISSION: 
            case FORBIDDEN: 
            case AUTHENTICATION_CLIENT_FORBIDDEN: 
            case UNAUTHENTICATED_EXCEPTION: 
            case UNAUTHORIZED_EXCEPTION: 
            case UNAUTHORIZED_ANONYMOUS: 
            case NO_USER_FOUND_EXCEPTION: 
            case USER_DISABLED_EXCEPTION: 
            case TOKEN_ACCESS_FORBIDDEN: {
                return "\u6ca1\u6709\u6743\u9650";
            }
            case NOT_FOUND: {
                return "\u8bf7\u6c42\u7684\u5185\u5bb9\u4e0d\u5b58\u5728";
            }
            case LOGIN_EXCEPTION: 
            case AUTHENTICATION_EXCEPTION: {
                return "\u767b\u5f55\u5931\u8d25";
            }
            case VERIFICATION_CODE_EXCEPTION: {
                return "\u9a8c\u8bc1\u7801\u9519\u8bef";
            }
            case PARAMETER_PARSE_EXCEPTION: {
                return "\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e";
            }
        }
        String ms = null;
        if (StringUtils.hasText((String)CloudtContextHolder.getGlobalDefaultErrorMsg())) {
            ms = StrUtil.format((CharSequence)CloudtContextHolder.getGlobalDefaultErrorMsg(), Map.of("errorNo", (String)ObjectUtil.defaultIfNull((Object)errorNo, (Object)"001")));
        }
        return (String)ObjectUtil.defaultIfNull(ms, (Object)"\u7cfb\u7edf\u7e41\u5fd9, \u8bf7\u7a0d\u540e\u518d\u8bd5");
    }
}

