package com.elitesland.fin.service.pay;

import com.elitesland.fin.Application;
import com.elitesland.fin.dto.pay.DrawBackResultDTO;
import com.elitesland.fin.dto.pay.DrawBackRpcDTO;
import com.elitesland.fin.dto.pay.PayRpcDTO;
import com.elitesland.fin.dto.pay.PayRpcResultDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author zhiyu.he
 * @date 2022/12/28 10:28
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + PayRpcService.PATH)
public interface PayRpcService {
    String PATH = "/pay";
    //订单支付接口 未实现直接返回成功  随机生成流水号
    @PostMapping("/payment")
    PayRpcResultDTO pay(@RequestBody PayRpcDTO payRpcDTO);

    //订单退款接口 未实现直接返回成功 随机生成流水号
    @PostMapping("/drawBack")
    DrawBackResultDTO drawBack(@RequestBody DrawBackRpcDTO drawBackRpcDTO);
}
